/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.entity;

import com.ayutaki.chinjufumod.entity.Explosion_CM;
import com.ayutaki.chinjufumod.handler.EntityTypes_CM;
import com.ayutaki.chinjufumod.handler.SoundEvents_CM;
import com.ayutaki.chinjufumod.registry.Items_Weapon;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Gyorai61cmEntity
extends ThrowableProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(Gyorai61cmEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.m_135353_(Gyorai61cmEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private ItemStack projectile = new ItemStack((ItemLike)Items_Weapon.GYORAI_61cm.get());
    private double baseDamage = 10.0;

    public Gyorai61cmEntity(EntityType<Gyorai61cmEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public Gyorai61cmEntity(LivingEntity entityIn, Level world, ItemStack stack) {
        super((EntityType)EntityTypes_CM.GYORAI61.get(), entityIn, world);
        this.projectile = stack.m_41777_();
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ID_FLAGS, (Object)0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_6128_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        if (!this.m_9236_().f_46443_ && this.f_19797_ >= 60) {
            this.dropAndKill();
        }
    }

    private void dropAndKill() {
        ItemStack stack = this.getItemStack();
        stack.m_41764_(1);
        ItemEntity item = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)item);
        this.m_146870_();
    }

    private ItemStack getItemStack() {
        return this.projectile.m_41777_();
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type hitresult$type = result.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)result);
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)result);
        }
    }

    protected void m_5790_(@Nonnull EntityHitResult result) {
        super.m_5790_(result);
        double dealDamage = this.baseDamage;
        float criticalA = this.f_19796_.m_188503_(4) == 0 ? 1.5f : 1.0f;
        float criticalB = this.f_19796_.m_188503_(8) == 0 ? 1.25f : 0.9f;
        float criGYORAI = this.isSuirai() ? criticalA : criticalB;
        result.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)dealDamage * criGYORAI);
        this.hitProcess();
        this.m_146870_();
    }

    protected void m_8060_(@Nonnull BlockHitResult result) {
        super.m_8060_(result);
        BlockState state = this.m_9236_().m_8055_(result.m_82425_());
        Block block = state.m_60734_();
        if (state.m_247087_() || block == Blocks.f_50575_) {
            return;
        }
        if (!state.m_247087_() && block != Blocks.f_50575_) {
            this.hitProcess();
            this.m_146870_();
        }
    }

    protected float m_7139_() {
        if (this.f_19800_) {
            return 0.0f;
        }
        return 0.01f;
    }

    public boolean m_20069_() {
        return false;
    }

    public void setSuirai(boolean flag) {
        this.setFlag(1, flag);
    }

    private void setFlag(int value, boolean flag) {
        byte b0 = (Byte)this.f_19804_.m_135370_(ID_FLAGS);
        if (flag) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)(b0 | value)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)(b0 & ~value)));
        }
    }

    public boolean isSuirai() {
        byte b0 = (Byte)this.f_19804_.m_135370_(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public void setItem(ItemStack stack) {
        if (!stack.m_150930_(this.getDefaultItem()) || stack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)stack.m_41777_(), consumer -> consumer.m_41764_(1))));
        }
    }

    protected Item getDefaultItem() {
        return this.projectile.m_41720_();
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack m_7846_() {
        ItemStack stack = this.getItemRaw();
        return stack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : stack;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ItemStack stack = this.getItemRaw();
        if (!stack.m_41619_()) {
            compound.m_128365_("Item", (Tag)stack.m_41739_(new CompoundTag()));
        }
        compound.m_128347_("damage", this.baseDamage);
        compound.m_128379_("suirai", this.isSuirai());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ItemStack stack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Item"));
        this.setItem(stack);
        if (compound.m_128425_("damage", 99)) {
            this.baseDamage = compound.m_128459_("damage");
        }
        this.setSuirai(compound.m_128471_("suirai"));
    }

    public void setBaseDamage(double damage) {
        this.baseDamage = damage;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void hitProcess() {
        if (!this.m_9236_().f_46443_) {
            float addGYORAI = this.isSuirai() ? 1.5f : 1.0f;
            this.createExplosion((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), addGYORAI, false, Explosion.BlockInteraction.KEEP);
        }
        this.m_5496_((SoundEvent)SoundEvents_CM.AM_IMPACT.get(), 2.0f, 0.8f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.m_9236_().m_7605_((Entity)this, (byte)3);
    }

    public Explosion_CM createExplosion(@Nullable Entity entityIn, double xIn, double yIn, double zIn, float value, boolean flag, Explosion.BlockInteraction mode) {
        return this.explode(entityIn, null, null, xIn, yIn, zIn, value, flag, mode);
    }

    public Explosion_CM explode(@Nullable Entity entityIn, @Nullable DamageSource damage, @Nullable ExplosionDamageCalculator context, double xIn, double yIn, double zIn, float value, boolean flag, Explosion.BlockInteraction mode) {
        Explosion_CM explosion = new Explosion_CM(this.m_9236_(), (Entity)this, damage, context, xIn, yIn, zIn, value, flag, mode);
        explosion.m_46061_();
        explosion.m_46075_(true);
        return explosion;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            for (int re = 0; re < 4; ++re) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }
}

