/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Weak_Explosion
extends Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private final boolean fire;
    private final Explosion.BlockInteraction blockInteraction;
    private final RandomSource random = RandomSource.m_216327_();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();
    private final Vec3 position;

    public Weak_Explosion(Level worldIn, @Nullable Entity entityIn, double xIn, double yIn, double zIn, float sizeIn) {
        this(worldIn, entityIn, xIn, yIn, zIn, sizeIn, false, Explosion.BlockInteraction.KEEP);
    }

    public Weak_Explosion(Level worldIn, @Nullable Entity entityIn, double xIn, double yIn, double zIn, float sizeIn, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, xIn, yIn, zIn, sizeIn, false, Explosion.BlockInteraction.KEEP, affectedPositions);
    }

    public Weak_Explosion(Level worldIn, @Nullable Entity entityIn, double xIn, double yIn, double zIn, float sizeIn, boolean fireIn, Explosion.BlockInteraction mode, List<BlockPos> p_46049_) {
        this(worldIn, entityIn, xIn, yIn, zIn, sizeIn, fireIn, mode);
        this.toBlow.addAll(p_46049_);
    }

    public Weak_Explosion(Level worldIn, @Nullable Entity entityIn, double xIn, double yIn, double zIn, float sizeIn, boolean fireIn, Explosion.BlockInteraction mode) {
        this(worldIn, entityIn, null, null, xIn, yIn, zIn, sizeIn, fireIn, mode);
    }

    public Weak_Explosion(Level worldIn, @Nullable Entity entityIn, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator context, double xIn, double yIn, double zIn, float sizeIn, boolean fireIn, Explosion.BlockInteraction mode) {
        super(worldIn, entityIn, source, context, xIn, yIn, zIn, sizeIn, fireIn, mode);
        this.level = worldIn;
        this.source = entityIn;
        this.radius = sizeIn;
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
        this.fire = fireIn;
        this.blockInteraction = mode;
        this.damageSource = source == null ? worldIn.m_269111_().m_269093_((Explosion)this) : source;
        this.damageCalculator = context == null ? this.m_46062_(entityIn) : context;
        this.position = new Vec3(this.x, this.y, this.z);
    }

    private ExplosionDamageCalculator m_46062_(@Nullable Entity entityIn) {
        return entityIn == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(entityIn);
    }

    public static float m_46064_(Vec3 vec, Entity entityIn) {
        AABB aabb = entityIn.m_20191_();
        double d0 = 1.0 / ((aabb.f_82291_ - aabb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.f_82292_ - aabb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.f_82293_ - aabb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d5 = Mth.m_14139_((double)f, (double)aabb.f_82288_, (double)aabb.f_82291_);
                        double d6 = Mth.m_14139_((double)f1, (double)aabb.f_82289_, (double)aabb.f_82292_);
                        double d7 = Mth.m_14139_((double)f2, (double)aabb.f_82290_, (double)aabb.f_82293_);
                        Vec3 vec3 = new Vec3(d5 + d3, d6, d7 + d4);
                        if (entityIn.m_9236_().m_45547_(new ClipContext(vec3, vec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityIn)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void m_46061_() {
        this.level.m_220400_(this.source, GameEvent.f_157812_, new Vec3(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos pos = BlockPos.m_274561_((double)d4, (double)d6, (double)d8);
                        BlockState state = this.level.m_8055_(pos);
                        FluidState fluidstate = this.level.m_6425_(pos);
                        if (!this.level.m_46739_(pos)) continue block2;
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, pos, state, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, pos, state, f)) {
                            set.add(pos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float f2 = this.radius * 2.0f;
        int k1 = Mth.m_14107_((double)(this.x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)f2 + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f2);
        Vec3 vec3 = new Vec3(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Player player;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || !((d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * d7 + (d9 = entity.m_20189_() - this.z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = Weak_Explosion.m_46064_(vec3, entity);
            double d10 = (1.0 - d12) * d14;
            entity.m_6469_(this.m_46077_(), 1.0f);
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)livingentity, (double)d10);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11 * 2.0, d7 * d11 * 0.5, d9 * d11 * 2.0));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.hitPlayers.put(player, new Vec3(d5 * d10 * 2.0, d7 * d10 * 0.5, d9 * d10 * 2.0));
        }
    }

    public void m_46075_(boolean spawnParticles) {
        boolean flag = this.m_254884_();
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Util.m_214673_(this.toBlow, (RandomSource)this.level.f_46441_);
            for (BlockPos blockpos : this.toBlow) {
                Level worldIn;
                BlockState blockstate = this.level.m_8055_(blockpos);
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.level.m_46473_().m_6180_("explosion_blocks");
                if (blockstate.canDropFromExplosion((BlockGetter)this.level, blockpos, (Explosion)this) && (worldIn = this.level) instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)worldIn;
                    BlockEntity blockentity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                    LootParams.Builder lootparams$builder = new LootParams.Builder(serverlevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.source);
                    if (this.blockInteraction == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
                        lootparams$builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                    }
                    blockstate.m_287290_(lootparams$builder).forEach(p_46074_ -> Weak_Explosion.m_46067_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_46074_, blockpos1));
                }
                blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
                this.level.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos pos2 : this.toBlow) {
                if (this.random.m_188503_(3) != 0 || !this.level.m_8055_(pos2).m_60795_() || !this.level.m_8055_(pos2.m_7495_()).m_60804_((BlockGetter)this.level, pos2.m_7495_())) continue;
                this.level.m_46597_(pos2, BaseFireBlock.m_49245_((BlockGetter)this.level, (BlockPos)pos2));
            }
        }
    }

    public boolean m_254884_() {
        return this.blockInteraction != Explosion.BlockInteraction.KEEP;
    }

    private static void m_46067_(ObjectArrayList<Pair<ItemStack, BlockPos>> object, ItemStack stack, BlockPos pos) {
        int i = object.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)object.get(j);
            ItemStack pairStack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)pairStack, (ItemStack)stack)) continue;
            ItemStack pairStack1 = ItemEntity.m_32029_((ItemStack)pairStack, (ItemStack)stack, (int)16);
            object.set(j, (Object)Pair.of((Object)pairStack1, (Object)((BlockPos)pair.getSecond())));
            if (!stack.m_41619_()) continue;
            return;
        }
        object.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public DamageSource m_46077_() {
        return this.damageSource;
    }

    public Map<Player, Vec3> m_46078_() {
        return this.hitPlayers;
    }

    @Nullable
    public LivingEntity m_252906_() {
        Projectile projectile;
        if (this.source == null) {
            return null;
        }
        Entity entity = this.source;
        if (entity instanceof PrimedTnt) {
            PrimedTnt primedtnt = (PrimedTnt)entity;
            return primedtnt.m_19749_();
        }
        entity = this.source;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            return livingentity;
        }
        entity = this.source;
        if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).m_19749_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void m_46080_() {
        this.toBlow.clear();
    }

    public List<BlockPos> m_46081_() {
        return this.toBlow;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    @Nullable
    public Entity getExploder() {
        return this.source;
    }

    public static enum BlockInteraction {
        KEEP,
        DESTROY,
        DESTROY_WITH_DECAY;

    }
}

