/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.items.teatime;

import com.ayutaki.chinjufumod.registry.Items_Teatime;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class MeasureCup_Item
extends BucketItem {
    private final Fluid content;
    private final Block block;

    public MeasureCup_Item(Fluid containedFluidIn, Block blockIn, Item.Properties properties) {
        super(containedFluidIn, properties);
        this.block = blockIn;
        this.content = containedFluidIn;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack hStack = playerIn.m_21120_(hand);
        BlockHitResult blockResult = MeasureCup_Item.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)(this.content == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)playerIn, (Level)worldIn, (ItemStack)hStack, (HitResult)blockResult);
        boolean mode = playerIn.m_150110_().f_35937_;
        BlockPos pos = blockResult.m_82425_();
        Direction direction = blockResult.m_82434_();
        BlockPos posDirect = pos.m_121945_(direction);
        BlockState state = worldIn.m_8055_(pos);
        Block block = state.m_60734_();
        if (ret != null) {
            return ret;
        }
        if (blockResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)hStack);
        }
        if (blockResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)hStack);
        }
        if (!playerIn.m_6047_() && worldIn.m_7966_(playerIn, pos) && playerIn.m_36204_(posDirect, direction, hStack) && this.content == Fluids.f_76191_) {
            if (block == Blocks.f_152476_) {
                int cauldron = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                if (cauldron > 1) {
                    playerIn.m_36220_(Stats.f_12944_);
                    worldIn.m_5594_(playerIn, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    ItemStack take = new ItemStack((ItemLike)Items_Teatime.KEIRYO_CUP_full.get(), 1);
                    if (!playerIn.m_150109_().m_36054_(take)) {
                        playerIn.m_36176_(take, false);
                    }
                    if (!mode) {
                        hStack.m_41774_(1);
                    }
                    if (mode) {
                        // empty if block
                    }
                    worldIn.m_7731_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(cauldron - 1)), 3);
                    return InteractionResultHolder.m_19090_((Object)hStack);
                }
                if (cauldron == 1) {
                    playerIn.m_36220_(Stats.f_12944_);
                    worldIn.m_5594_(playerIn, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    ItemStack take = new ItemStack((ItemLike)Items_Teatime.KEIRYO_CUP_full.get(), 1);
                    if (!playerIn.m_150109_().m_36054_(take)) {
                        playerIn.m_36176_(take, false);
                    }
                    if (!mode) {
                        hStack.m_41774_(1);
                    }
                    if (mode) {
                        // empty if block
                    }
                    worldIn.m_7731_(pos, Blocks.f_50256_.m_49966_(), 3);
                    return InteractionResultHolder.m_19090_((Object)hStack);
                }
                return InteractionResultHolder.m_19098_((Object)hStack);
            }
            if (worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
                worldIn.m_5594_(playerIn, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ItemStack take = new ItemStack((ItemLike)Items_Teatime.KEIRYO_CUP_full.get(), 1);
                if (!playerIn.m_150109_().m_36054_(take)) {
                    playerIn.m_36176_(take, false);
                }
                if (!mode) {
                    hStack.m_41774_(1);
                }
                if (mode) {
                    // empty if block
                }
                return InteractionResultHolder.m_19090_((Object)hStack);
            }
            return InteractionResultHolder.m_19098_((Object)hStack);
        }
        return InteractionResultHolder.m_19098_((Object)hStack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player playerIn = context.m_43723_();
        if (context.m_43719_() == Direction.UP && (playerIn.m_6047_() || playerIn.m_20159_())) {
            return this.place(new BlockPlaceContext(context));
        }
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockplacecontext = this.updatePlacementContext(context);
        if (blockplacecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState state = this.getPlacementState(blockplacecontext);
        if (state == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockplacecontext, state)) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = blockplacecontext.m_8083_();
        Level worldIn = blockplacecontext.m_43725_();
        Player playerIn = blockplacecontext.m_43723_();
        ItemStack stack = blockplacecontext.m_43722_();
        BlockState state1 = worldIn.m_8055_(pos);
        if (state1.m_60713_(state.m_60734_())) {
            state1 = this.updateBlockStateFromTag(pos, worldIn, stack, state1);
            this.updateCustomBlockEntityTag(pos, worldIn, playerIn, stack, state1);
            state1.m_60734_().m_6402_(worldIn, pos, state1, (LivingEntity)playerIn, stack);
            if (playerIn instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)playerIn, pos, stack);
            }
        }
        worldIn.m_142346_((Entity)playerIn, GameEvent.f_157797_, pos);
        SoundType soundtype = state1.getSoundType((LevelReader)worldIn, pos, (Entity)context.m_43723_());
        worldIn.m_5594_(playerIn, pos, this.getPlaceSound(state1, worldIn, pos, context.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (playerIn == null || !playerIn.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    protected SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)world, pos, (Entity)entity).m_56777_();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level worldIn, @Nullable Player playerIn, ItemStack stack, BlockState state) {
        return MeasureCup_Item.updateCustomBlockEntityTag(worldIn, playerIn, pos, stack);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState state = this.getBlock().m_5573_(context);
        return state != null && this.canPlace(context, state) ? state : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos pos, Level worldIn, ItemStack stack, BlockState state) {
        BlockState state1 = state;
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null) {
            CompoundTag compoundtag1 = compoundtag.m_128469_("BlockStateTag");
            StateDefinition statedefinition = state.m_60734_().m_49965_();
            for (String s : compoundtag1.m_128431_()) {
                Property property = statedefinition.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundtag1.m_128423_(s).m_7916_();
                state1 = MeasureCup_Item.updateState(state1, property, s1);
            }
        }
        if (state1 != state) {
            worldIn.m_7731_(pos, state1, 2);
        }
        return state1;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> propertyIn, String string) {
        return propertyIn.m_6215_(string).map(p_40592_ -> (BlockState)state.m_61124_(propertyIn, p_40592_)).orElse(state);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player playerIn = context.m_43723_();
        CollisionContext collisioncontext = playerIn == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)playerIn);
        return (!this.mustSurvive() || state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) && context.m_43725_().m_45752_(state, context.m_8083_(), collisioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    public static boolean updateCustomBlockEntityTag(Level worldIn, @Nullable Player playerIn, BlockPos pos, ItemStack stack) {
        BlockEntity blockentity;
        MinecraftServer minecraftserver = worldIn.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag compoundtag = MeasureCup_Item.getBlockEntityData(stack);
        if (compoundtag != null && (blockentity = worldIn.m_7702_(pos)) != null) {
            if (!(worldIn.f_46443_ || !blockentity.m_6326_() || playerIn != null && playerIn.m_36337_())) {
                return false;
            }
            CompoundTag compoundtag1 = blockentity.m_187482_();
            CompoundTag compoundtag2 = compoundtag1.m_6426_();
            compoundtag1.m_128391_(compoundtag);
            if (!compoundtag1.equals((Object)compoundtag2)) {
                blockentity.m_142466_(compoundtag1);
                blockentity.m_6596_();
                return true;
            }
        }
        return false;
    }

    public Block getBlock() {
        return this.getBlockRaw() == null ? null : (Block)ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)this.getBlockRaw()).get();
    }

    private Block getBlockRaw() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> blockItem, Item itemIn) {
        blockItem.put(this.getBlock(), itemIn);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        blockToItemMap.remove(this.getBlock());
    }

    @Nullable
    public static CompoundTag getBlockEntityData(ItemStack stack) {
        return stack.m_41737_("BlockEntityTag");
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag tipFlag) {
        tooltip.add((Component)Component.m_237115_((String)"tips.block_measurecup").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tips.block_simpledish").m_130940_(ChatFormatting.GRAY));
    }
}

