/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractStoveTileEntity
extends AbstractFurnaceBlockEntity {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return AbstractStoveTileEntity.this.litTime;
                }
                case 1: {
                    return AbstractStoveTileEntity.this.litDuration;
                }
                case 2: {
                    return AbstractStoveTileEntity.this.cookingProgress;
                }
                case 3: {
                    return AbstractStoveTileEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractStoveTileEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    AbstractStoveTileEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    AbstractStoveTileEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    AbstractStoveTileEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractStoveTileEntity(BlockEntityType<?> tileType, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> recipeTypeIn) {
        super(tileType, pos, state, recipeTypeIn);
        this.quickCheck = RecipeManager.m_220267_(recipeTypeIn);
        this.recipeType = recipeTypeIn;
    }

    @Deprecated
    public static Map<Item, Integer> m_58423_() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42448_, 20000);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50353_, 16000);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42585_, 2400);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42413_, 1600);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42414_, 1600);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13182_, 300);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_256904_, 300);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13168_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_244489_, 300);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13174_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_244193_, 300);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13175_, 150);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_244230_, 150);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13178_, 300);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13177_, 300);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13176_, 300);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_254662_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50065_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50078_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_244299_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50624_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50131_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50087_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50325_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50091_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50329_, 300);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13191_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42411_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42523_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50155_, 300);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13157_, 200);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_244389_, 800);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42421_, 200);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42420_, 200);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42424_, 200);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42423_, 200);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42422_, 200);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13173_, 200);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13155_, 1200);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13167_, 100);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13170_, 100);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42398_, 100);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_13180_, 100);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42399_, 100);
        AbstractStoveTileEntity.m_204302_(map, (TagKey<Item>)ItemTags.f_215867_, 67);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50577_, 4001);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Items.f_42717_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50571_, 50);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50036_, 100);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50616_, 50);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50617_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50618_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50621_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50622_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50625_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_50715_, 300);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_152541_, 100);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_152542_, 100);
        AbstractStoveTileEntity.m_58374_(map, (ItemLike)Blocks.f_220833_, 300);
        return map;
    }

    private static boolean m_58397_(Item item) {
        return item.m_204114_().m_203656_(ItemTags.f_13153_);
    }

    private static void m_204302_(Map<Item, Integer> map, TagKey<Item> itemProvider, int burnTime) {
        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(itemProvider)) {
            if (AbstractStoveTileEntity.m_58397_((Item)holder.m_203334_())) continue;
            map.put((Item)holder.m_203334_(), burnTime);
        }
    }

    private static void m_58374_(Map<Item, Integer> map, ItemLike itemProvider, int burnTime) {
        Item item = itemProvider.m_5456_();
        if (AbstractStoveTileEntity.m_58397_(item)) {
            if (SharedConstants.f_136183_) {
                throw (IllegalStateException)Util.m_137570_((Throwable)new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.m_7626_((ItemStack)null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            map.put(item, burnTime);
        }
    }

    private boolean m_58425_() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        this.litTime = compound.m_128451_("BurnTime");
        this.cookingProgress = compound.m_128451_("CookTime");
        this.cookingTotalTime = compound.m_128451_("CookTimeTotal");
        this.litDuration = this.m_7743_((ItemStack)this.items.get(1));
        CompoundTag compoundtag = compound.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("BurnTime", this.litTime);
        compound.m_128405_("CookTime", this.cookingProgress);
        compound.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.m_128405_(p_187449_.toString(), p_187450_.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public static void serverTick(Level worldIn, BlockPos pos, BlockState state, AbstractStoveTileEntity tileEntity) {
        boolean flag3;
        boolean flag = tileEntity.m_58425_();
        boolean flag1 = false;
        if (tileEntity.m_58425_()) {
            --tileEntity.litTime;
        }
        ItemStack itemstack = (ItemStack)tileEntity.items.get(1);
        boolean flag2 = !((ItemStack)tileEntity.items.get(0)).m_41619_();
        boolean bl = flag3 = !itemstack.m_41619_();
        if (tileEntity.m_58425_() || flag3 && flag2) {
            RecipeHolder recipe = flag2 ? (RecipeHolder)tileEntity.quickCheck.m_213657_((Container)tileEntity, worldIn).orElse(null) : null;
            int i = tileEntity.m_6893_();
            if (!tileEntity.m_58425_() && tileEntity.m_155005_(worldIn.m_9598_(), recipe, tileEntity.items, i)) {
                tileEntity.litDuration = tileEntity.litTime = tileEntity.m_7743_(itemstack);
                if (tileEntity.m_58425_()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        tileEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                    } else if (flag3) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            tileEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (tileEntity.m_58425_() && tileEntity.m_155005_(worldIn.m_9598_(), recipe, tileEntity.items, i)) {
                ++tileEntity.cookingProgress;
                if (tileEntity.cookingProgress == tileEntity.cookingTotalTime) {
                    tileEntity.cookingProgress = 0;
                    tileEntity.cookingTotalTime = AbstractStoveTileEntity.getTotalCookTime(worldIn, tileEntity);
                    if (tileEntity.m_266209_(worldIn.m_9598_(), recipe, tileEntity.items, i)) {
                        tileEntity.m_40156_(recipe);
                    }
                    flag1 = true;
                }
            } else {
                tileEntity.cookingProgress = 0;
            }
        } else if (!tileEntity.m_58425_() && tileEntity.cookingProgress > 0) {
            tileEntity.cookingProgress = Mth.m_14045_((int)(tileEntity.cookingProgress - 2), (int)0, (int)tileEntity.cookingTotalTime);
        }
        if (flag != tileEntity.m_58425_()) {
            flag1 = true;
            state = (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(tileEntity.m_58425_()));
            worldIn.m_7731_(pos, state, 3);
        }
        if (flag1) {
            AbstractStoveTileEntity.m_155232_((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean m_155005_(RegistryAccess access, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> list, int size) {
        if (!((ItemStack)list.get(0)).m_41619_() && recipe != null) {
            ItemStack itemstack = recipe.f_291008_().m_5874_((Container)this, access);
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)list.get(2);
            if (itemstack1.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            if (itemstack1.m_41613_() + itemstack.m_41613_() <= size && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                return true;
            }
            return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    private boolean m_266209_(RegistryAccess access, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> list, int size) {
        if (recipe != null && this.m_155005_(access, recipe, list, size)) {
            ItemStack itemstack = (ItemStack)list.get(0);
            ItemStack itemstack1 = recipe.f_291008_().m_5874_((Container)this, access);
            ItemStack itemstack2 = (ItemStack)list.get(2);
            if (itemstack2.m_41619_()) {
                list.set(2, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_150930_(itemstack1.m_41720_())) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            if (itemstack.m_150930_(Blocks.f_50057_.m_5456_()) && !((ItemStack)list.get(1)).m_41619_() && ((ItemStack)list.get(1)).m_150930_(Items.f_42446_)) {
                list.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            itemstack.m_41774_(1);
            return true;
        }
        return false;
    }

    protected int m_7743_(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)stack, this.recipeType) / 2 * 3;
    }

    private static int getTotalCookTime(Level worldIn, AbstractStoveTileEntity tileEntity) {
        return tileEntity.quickCheck.m_213657_((Container)tileEntity, worldIn).map(recipe -> ((AbstractCookingRecipe)recipe.f_291008_()).m_43753_()).orElse(200);
    }

    public static boolean m_58399_(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    public int[] m_7071_(Direction facing) {
        if (facing == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return facing == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int count, ItemStack stack, @Nullable Direction facing) {
        return this.m_7013_(count, stack);
    }

    public boolean m_7157_(int count, ItemStack stack, Direction facing) {
        if (facing == Direction.DOWN && count == 1) {
            return stack.m_150930_(Items.f_42447_) || stack.m_150930_(Items.f_42446_);
        }
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int count) {
        return (ItemStack)this.items.get(count);
    }

    public ItemStack m_7407_(int count, int count2) {
        return ContainerHelper.m_18969_(this.items, (int)count, (int)count2);
    }

    public ItemStack m_8016_(int count) {
        return ContainerHelper.m_18966_(this.items, (int)count);
    }

    public void m_6836_(int count, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(count);
        boolean flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack);
        this.items.set(count, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (count == 0 && !flag) {
            this.cookingTotalTime = AbstractStoveTileEntity.getTotalCookTime(this.f_58857_, this);
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player playerIn) {
        return Container.m_272074_((BlockEntity)this, (Player)playerIn);
    }

    public boolean m_7013_(int count, ItemStack stack) {
        if (count == 2) {
            return false;
        }
        if (count != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return ForgeHooks.getBurnTime((ItemStack)stack, this.recipeType) > 0 || stack.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_40156_(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.f_291676_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> m_40158_() {
        return null;
    }

    public void m_58395_(Player playerIn, List<ItemStack> list) {
    }

    public void m_155003_(ServerPlayer playerIn) {
        List<RecipeHolder<?>> list = this.m_154995_(playerIn.m_284548_(), playerIn.m_20182_());
        playerIn.m_7281_(list);
        for (RecipeHolder<?> recipe : list) {
            if (recipe == null) continue;
            playerIn.m_280300_(recipe, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> m_154995_(ServerLevel worldIn, Vec3 vc3) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            worldIn.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                AbstractStoveTileEntity.m_154998_(worldIn, vc3, entry.getIntValue(), ((AbstractCookingRecipe)recipe.f_291008_()).m_43750_());
            });
        }
        return list;
    }

    private static void m_154998_(ServerLevel worldIn, Vec3 vc3, int count, float count_f) {
        int i = Mth.m_14143_((float)((float)count * count_f));
        float f = Mth.m_14187_((float)((float)count * count_f));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)worldIn, (Vec3)vc3, (int)i);
    }

    public void m_5809_(StackedContents helper) {
        for (ItemStack itemstack : this.items) {
            helper.m_36491_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

