/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.world.biome;

import com.ayutaki.chinjufumod.world.biome.BiomeKey_CM;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class BiomeBuilder_unUsed {
    private static final float VALLEY_SIZE = 0.05f;
    private static final float LOW_START = 0.26666668f;
    public static final float HIGH_START = 0.4f;
    private static final float HIGH_END = 0.93333334f;
    private static final float PEAK_SIZE = 0.1f;
    public static final float PEAK_START = 0.56666666f;
    private static final float PEAK_END = 0.7666667f;
    public static final float NEAR_INLAND_START = -0.11f;
    public static final float MID_INLAND_START = 0.03f;
    public static final float FAR_INLAND_START = 0.3f;
    public static final float EROSION_INDEX_1_START = -0.78f;
    public static final float EROSION_INDEX_2_START = -0.375f;
    private static final float EROSION_DEEP_DARK_DRYNESS_THRESHOLD = -0.225f;
    private static final float DEPTH_DEEP_DARK_DRYNESS_THRESHOLD = 0.9f;
    private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    private final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
    private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
    private final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
    private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
    private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
    private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
    private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
    private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{null, null, null, null, null}, {null, null, BiomeKey_CM.KAEDE_HILLS_KEY, BiomeKey_CM.ICHOH_HILLS_KEY, null}, {BiomeKey_CM.SAKURA_FOREST_KEY, BiomeKey_CM.SAKURA_HILLS_KEY, BiomeKey_CM.KAEDE_FOREST_KEY, BiomeKey_CM.ICHOH_FOREST_KEY, null}, {null, null, null, null, null}, {null, null, null, null, null}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{null, null, null, null, null}, {null, null, null, null, null}, {BiomeKey_CM.SAKURA_FOREST_KEY, null, BiomeKey_CM.KAEDE_FOREST_KEY, BiomeKey_CM.ICHOH_FOREST_KEY, null}, {null, null, null, null, null}, {null, null, null, null, null}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{null, null, null, null, null}, {null, null, BiomeKey_CM.KAEDE_FOREST_KEY, BiomeKey_CM.ICHOH_FOREST_KEY, null}, {BiomeKey_CM.SAKURA_FOREST_KEY, null, BiomeKey_CM.KAEDE_FOREST_KEY, BiomeKey_CM.ICHOH_FOREST_KEY, null}, {null, null, null, BiomeKey_CM.SAKURA_FOREST_KEY, null}, {null, null, null, null, null}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{null, null, null, null, null}, {null, null, null, null, null}, {BiomeKey_CM.SAKURA_FOREST_KEY, null, BiomeKey_CM.KAEDE_FOREST_KEY, BiomeKey_CM.ICHOH_FOREST_KEY, null}, {null, null, null, null, null}, {null, null, null, null, null}};

    public List<Climate.ParameterPoint> spawnTarget() {
        Climate.Parameter temp = Climate.Parameter.m_186820_((float)0.0f);
        return List.of(new Climate.ParameterPoint(this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.FULL_RANGE), this.FULL_RANGE, temp, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.16f), 0L), new Climate.ParameterPoint(this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.FULL_RANGE), this.FULL_RANGE, temp, Climate.Parameter.m_186822_((float)0.16f, (float)1.0f), 0L));
    }

    protected void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey) {
        if (SharedConstants.f_183698_) {
            this.addDebugBiomes(biomeKey);
        } else {
            this.addInlandBiomes(biomeKey);
            this.addUndergroundBiomes(biomeKey);
        }
    }

    private void addDebugBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey) {
        CubicSpline cubicspline1;
        HolderLookup.Provider lookUp = VanillaRegistries.m_255371_();
        HolderLookup.RegistryLookup density = lookUp.m_255025_(Registries.f_257040_);
        DensityFunctions.Spline.Coordinate coordinate = new DensityFunctions.Spline.Coordinate((Holder)density.m_255043_(NoiseRouterData.f_209451_));
        DensityFunctions.Spline.Coordinate coordinate1 = new DensityFunctions.Spline.Coordinate((Holder)density.m_255043_(NoiseRouterData.f_209452_));
        DensityFunctions.Spline.Coordinate coordinate2 = new DensityFunctions.Spline.Coordinate((Holder)density.m_255043_(NoiseRouterData.f_224429_));
        biomeKey.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)this.FULL_RANGE, (float)0.01f), (Object)Biomes.f_48202_));
        CubicSpline cubicspline = TerrainProvider.m_236595_((ToFloatFunction)coordinate1, (ToFloatFunction)coordinate2, (float)-0.15f, (float)0.0f, (float)0.0f, (float)0.1f, (float)0.0f, (float)-0.03f, (boolean)false, (boolean)false, (ToFloatFunction)ToFloatFunction.f_216471_);
        if (cubicspline instanceof CubicSpline.Multipoint) {
            CubicSpline.Multipoint multipoint = (CubicSpline.Multipoint)cubicspline;
            ResourceKey resourcekey = Biomes.f_48203_;
            for (float f : multipoint.f_184320_()) {
                biomeKey.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)Climate.Parameter.m_186820_((float)f), (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)this.FULL_RANGE, (float)0.0f), (Object)resourcekey));
                resourcekey = resourcekey == Biomes.f_48203_ ? Biomes.f_48159_ : Biomes.f_48203_;
            }
        }
        if ((cubicspline1 = TerrainProvider.m_236635_((ToFloatFunction)coordinate, (ToFloatFunction)coordinate1, (ToFloatFunction)coordinate2, (boolean)false)) instanceof CubicSpline.Multipoint) {
            CubicSpline.Multipoint multipoint1 = (CubicSpline.Multipoint)cubicspline1;
            for (float f1 : multipoint1.f_184320_()) {
                biomeKey.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)Climate.Parameter.m_186820_((float)f1), (Climate.Parameter)this.FULL_RANGE, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)this.FULL_RANGE, (float)0.0f), (Object)Biomes.f_48152_));
            }
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey) {
        this.addMidSlice(biomeKey, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(biomeKey, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(biomeKey, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(biomeKey, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(biomeKey, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(biomeKey, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
        this.addValleys(biomeKey, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
        this.addLowSlice(biomeKey, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
        this.addMidSlice(biomeKey, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
        this.addHighSlice(biomeKey, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
        this.addPeaks(biomeKey, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(biomeKey, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(biomeKey, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey, Climate.Parameter par) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temp = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter moisture = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, par);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, par);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, par);
                ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, par);
                ResourceKey<Biome> resourcekey6 = this.pickPeakBiome(i, j, par);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], par, 0.0f, resourcekey6);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], par, 0.0f, resourcekey2);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], par, 0.0f, resourcekey6);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], par, 0.0f, resourcekey3);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.midInlandContinentalness, this.erosions[3], par, 0.0f, resourcekey1);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.farInlandContinentalness, this.erosions[3], par, 0.0f, resourcekey3);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, resourcekey);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey, Climate.Parameter par) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temp = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter moisture = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, par);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, par);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, par);
                ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, par);
                ResourceKey<Biome> resourcekey5 = this.maybePickWindsweptSavannaBiome(i, j, par, resourcekey);
                ResourceKey<Biome> resourcekey6 = this.pickSlopeBiome(i, j, par);
                ResourceKey<Biome> resourcekey7 = this.pickPeakBiome(i, j, par);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.nearInlandContinentalness, this.erosions[0], par, 0.0f, resourcekey6);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], par, 0.0f, resourcekey7);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.nearInlandContinentalness, this.erosions[1], par, 0.0f, resourcekey2);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], par, 0.0f, resourcekey6);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], par, 0.0f, resourcekey3);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.midInlandContinentalness, this.erosions[3], par, 0.0f, resourcekey1);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.farInlandContinentalness, this.erosions[3], par, 0.0f, resourcekey3);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], par, 0.0f, resourcekey5);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, resourcekey);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey, Climate.Parameter par) {
        this.addSurfaceBiome(biomeKey, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), par, 0.0f, (ResourceKey<Biome>)Biomes.f_186760_);
        this.addSurfaceBiome(biomeKey, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[2]), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, (ResourceKey<Biome>)Biomes.f_48207_);
        this.addSurfaceBiome(biomeKey, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, (ResourceKey<Biome>)Biomes.f_220595_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temp = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter moisture = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, par);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, par);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, par);
                ResourceKey<Biome> resourcekey4 = this.pickPlateauBiome(i, j, par);
                ResourceKey<Biome> resourcekey5 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> resourcekey6 = this.maybePickWindsweptSavannaBiome(i, j, par, resourcekey);
                ResourceKey<Biome> resourcekey7 = this.pickShatteredCoastBiome(i, j, par);
                ResourceKey<Biome> resourcekey8 = this.pickSlopeBiome(i, j, par);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], par, 0.0f, resourcekey8);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], par, 0.0f, resourcekey2);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.farInlandContinentalness, this.erosions[1], par, 0.0f, i == 0 ? resourcekey8 : resourcekey4);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.nearInlandContinentalness, this.erosions[2], par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.midInlandContinentalness, this.erosions[2], par, 0.0f, resourcekey1);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.farInlandContinentalness, this.erosions[2], par, 0.0f, resourcekey4);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], par, 0.0f, resourcekey1);
                if (par.f_186814_() < 0L) {
                    this.addSurfaceBiome(biomeKey, temp, moisture, this.coastContinentalness, this.erosions[4], par, 0.0f, resourcekey5);
                    this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], par, 0.0f, resourcekey);
                } else {
                    this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], par, 0.0f, resourcekey);
                }
                this.addSurfaceBiome(biomeKey, temp, moisture, this.coastContinentalness, this.erosions[5], par, 0.0f, resourcekey7);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.nearInlandContinentalness, this.erosions[5], par, 0.0f, resourcekey6);
                if (par.f_186814_() < 0L) {
                    this.addSurfaceBiome(biomeKey, temp, moisture, this.coastContinentalness, this.erosions[6], par, 0.0f, resourcekey5);
                } else {
                    this.addSurfaceBiome(biomeKey, temp, moisture, this.coastContinentalness, this.erosions[6], par, 0.0f, resourcekey);
                }
                if (i != 0) continue;
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, resourcekey);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey, Climate.Parameter par) {
        this.addSurfaceBiome(biomeKey, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), par, 0.0f, (ResourceKey<Biome>)Biomes.f_186760_);
        this.addSurfaceBiome(biomeKey, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[2]), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, (ResourceKey<Biome>)Biomes.f_48207_);
        this.addSurfaceBiome(biomeKey, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, (ResourceKey<Biome>)Biomes.f_220595_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temp = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter moisture = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, par);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, par);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, par);
                ResourceKey<Biome> resourcekey3 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> resourcekey4 = this.maybePickWindsweptSavannaBiome(i, j, par, resourcekey);
                ResourceKey<Biome> resourcekey5 = this.pickShatteredCoastBiome(i, j, par);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), par, 0.0f, resourcekey1);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), par, 0.0f, resourcekey2);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), par, 0.0f, resourcekey1);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), par, 0.0f, resourcekey3);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.coastContinentalness, this.erosions[5], par, 0.0f, resourcekey5);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.nearInlandContinentalness, this.erosions[5], par, 0.0f, resourcekey4);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], par, 0.0f, resourcekey);
                this.addSurfaceBiome(biomeKey, temp, moisture, this.coastContinentalness, this.erosions[6], par, 0.0f, resourcekey3);
                if (i != 0) continue;
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, resourcekey);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey, Climate.Parameter par) {
        this.addSurfaceBiome(biomeKey, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), par, 0.0f, (ResourceKey<Biome>)(par.f_186814_() < 0L ? Biomes.f_186760_ : Biomes.f_48212_));
        this.addSurfaceBiome(biomeKey, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), par, 0.0f, (ResourceKey<Biome>)(par.f_186814_() < 0L ? Biomes.f_186760_ : Biomes.f_48208_));
        this.addSurfaceBiome(biomeKey, this.FROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), par, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(biomeKey, this.UNFROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), par, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.addSurfaceBiome(biomeKey, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), par, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(biomeKey, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), par, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.addSurfaceBiome(biomeKey, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], par, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(biomeKey, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], par, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.addSurfaceBiome(biomeKey, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[2]), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, (ResourceKey<Biome>)Biomes.f_48207_);
        this.addSurfaceBiome(biomeKey, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, (ResourceKey<Biome>)Biomes.f_220595_);
        this.addSurfaceBiome(biomeKey, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], par, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temp = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter moisture = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiomeOrBadlandsIfHot(i, j, par);
                this.addSurfaceBiome(biomeKey, temp, moisture, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), par, 0.0f, resourcekey);
            }
        }
    }

    private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey) {
        this.addUndergroundBiome(biomeKey, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.f_151784_);
        this.addUndergroundBiome(biomeKey, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.7f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.f_151785_);
        this.addBottomBiome(biomeKey, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.f_220594_);
    }

    private ResourceKey<Biome> pickMiddleBiome(int p_187164_, int p_187165_, Climate.Parameter par) {
        if (par.f_186814_() < 0L) {
            return this.MIDDLE_BIOMES[p_187164_][p_187165_];
        }
        ResourceKey<Biome> resourcekey = this.MIDDLE_BIOMES_VARIANT[p_187164_][p_187165_];
        return resourcekey == null ? this.MIDDLE_BIOMES[p_187164_][p_187165_] : resourcekey;
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHot(int p_187192_, int p_187193_, Climate.Parameter par) {
        return p_187192_ == 4 ? this.pickBadlandsBiome(p_187193_, par) : this.pickMiddleBiome(p_187192_, p_187193_, par);
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(int p_187212_, int p_187213_, Climate.Parameter par) {
        return p_187212_ == 0 ? this.pickSlopeBiome(p_187212_, p_187213_, par) : this.pickMiddleBiomeOrBadlandsIfHot(p_187212_, p_187213_, par);
    }

    private ResourceKey<Biome> maybePickWindsweptSavannaBiome(int p_201991_, int p_201992_, Climate.Parameter par, ResourceKey<Biome> biomeKey) {
        return p_201991_ > 1 && p_201992_ < 4 && par.f_186814_() >= 0L ? Biomes.f_186768_ : biomeKey;
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(int p_187223_, int p_187224_, Climate.Parameter par) {
        ResourceKey<Biome> resourcekey = par.f_186814_() >= 0L ? this.pickMiddleBiome(p_187223_, p_187224_, par) : this.pickBeachBiome(p_187223_, p_187224_);
        return this.maybePickWindsweptSavannaBiome(p_187223_, p_187224_, par, resourcekey);
    }

    private ResourceKey<Biome> pickBeachBiome(int p_187161_, int p_187162_) {
        if (p_187161_ == 0) {
            return Biomes.f_48148_;
        }
        return p_187161_ == 4 ? Biomes.f_48203_ : Biomes.f_48217_;
    }

    private ResourceKey<Biome> pickBadlandsBiome(int p_187173_, Climate.Parameter par) {
        if (p_187173_ < 2) {
            return par.f_186814_() < 0L ? Biomes.f_48159_ : Biomes.f_48194_;
        }
        return p_187173_ < 3 ? Biomes.f_48159_ : Biomes.f_186753_;
    }

    private ResourceKey<Biome> pickPlateauBiome(int p_187234_, int p_187235_, Climate.Parameter par) {
        ResourceKey<Biome> resourcekey;
        if (par.f_186814_() >= 0L && (resourcekey = this.PLATEAU_BIOMES_VARIANT[p_187234_][p_187235_]) != null) {
            return resourcekey;
        }
        return this.PLATEAU_BIOMES[p_187234_][p_187235_];
    }

    private ResourceKey<Biome> pickPeakBiome(int p_187241_, int p_187242_, Climate.Parameter par) {
        if (p_187241_ <= 2) {
            return par.f_186814_() < 0L ? Biomes.f_186758_ : Biomes.f_186757_;
        }
        return p_187241_ == 3 ? Biomes.f_186759_ : this.pickBadlandsBiome(p_187242_, par);
    }

    private ResourceKey<Biome> pickSlopeBiome(int p_187245_, int p_187246_, Climate.Parameter par) {
        if (p_187245_ >= 3) {
            return this.pickPlateauBiome(p_187245_, p_187246_, par);
        }
        return p_187246_ <= 1 ? Biomes.f_186756_ : Biomes.f_186755_;
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey, Climate.Parameter par, Climate.Parameter par1, Climate.Parameter par2, Climate.Parameter par3, Climate.Parameter par4, float f, ResourceKey<Biome> biomeKey1) {
        biomeKey.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)par, (Climate.Parameter)par1, (Climate.Parameter)par2, (Climate.Parameter)par3, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)par4, (float)f), biomeKey1));
        biomeKey.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)par, (Climate.Parameter)par1, (Climate.Parameter)par2, (Climate.Parameter)par3, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)par4, (float)f), biomeKey1));
    }

    private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey, Climate.Parameter par, Climate.Parameter par1, Climate.Parameter par2, Climate.Parameter par3, Climate.Parameter par4, float f, ResourceKey<Biome> biomeKey1) {
        biomeKey.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)par, (Climate.Parameter)par1, (Climate.Parameter)par2, (Climate.Parameter)par3, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), (Climate.Parameter)par4, (float)f), biomeKey1));
    }

    private void addBottomBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> biomeKey, Climate.Parameter par, Climate.Parameter par1, Climate.Parameter par2, Climate.Parameter par3, Climate.Parameter par4, float f, ResourceKey<Biome> biomeKey1) {
        biomeKey.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)par, (Climate.Parameter)par1, (Climate.Parameter)par2, (Climate.Parameter)par3, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.1f), (Climate.Parameter)par4, (float)f), biomeKey1));
    }

    public static boolean isDeepDarkRegion(DensityFunction density, DensityFunction density1, DensityFunction.FunctionContext context) {
        return density.m_207386_(context) < (double)-0.225f && density1.m_207386_(context) > (double)0.9f;
    }

    public static String getDebugStringForPeaksAndValleys(double d) {
        if (d < (double)NoiseRouterData.m_224435_((float)0.05f)) {
            return "Valley";
        }
        if (d < (double)NoiseRouterData.m_224435_((float)0.26666668f)) {
            return "Low";
        }
        if (d < (double)NoiseRouterData.m_224435_((float)0.4f)) {
            return "Mid";
        }
        return d < (double)NoiseRouterData.m_224435_((float)0.56666666f) ? "High" : "Peak";
    }

    public String getDebugStringForContinentalness(double d) {
        double d0 = Climate.m_186779_((float)((float)d));
        if (d0 < (double)this.mushroomFieldsContinentalness.f_186814_()) {
            return "Mushroom fields";
        }
        if (d0 < (double)this.deepOceanContinentalness.f_186814_()) {
            return "Deep ocean";
        }
        if (d0 < (double)this.oceanContinentalness.f_186814_()) {
            return "Ocean";
        }
        if (d0 < (double)this.coastContinentalness.f_186814_()) {
            return "Coast";
        }
        if (d0 < (double)this.nearInlandContinentalness.f_186814_()) {
            return "Near inland";
        }
        return d0 < (double)this.midInlandContinentalness.f_186814_() ? "Mid inland" : "Far inland";
    }

    public String getDebugStringForErosion(double d) {
        return BiomeBuilder_unUsed.getDebugStringForNoiseValue(d, this.erosions);
    }

    public String getDebugStringForTemperature(double d) {
        return BiomeBuilder_unUsed.getDebugStringForNoiseValue(d, this.temperatures);
    }

    public String getDebugStringForHumidity(double d) {
        return BiomeBuilder_unUsed.getDebugStringForNoiseValue(d, this.humidities);
    }

    private static String getDebugStringForNoiseValue(double d, Climate.Parameter[] par) {
        double d0 = Climate.m_186779_((float)((float)d));
        for (int i = 0; i < par.length; ++i) {
            if (!(d0 < (double)par[i].f_186814_())) continue;
            return "" + i;
        }
        return "?";
    }

    @VisibleForDebug
    public Climate.Parameter[] getTemperatureThresholds() {
        return this.temperatures;
    }

    @VisibleForDebug
    public Climate.Parameter[] getHumidityThresholds() {
        return this.humidities;
    }

    @VisibleForDebug
    public Climate.Parameter[] getErosionThresholds() {
        return this.erosions;
    }

    @VisibleForDebug
    public Climate.Parameter[] getContinentalnessThresholds() {
        return new Climate.Parameter[]{this.mushroomFieldsContinentalness, this.deepOceanContinentalness, this.oceanContinentalness, this.coastContinentalness, this.nearInlandContinentalness, this.midInlandContinentalness, this.farInlandContinentalness};
    }

    @VisibleForDebug
    public Climate.Parameter[] getPeaksAndValleysThresholds() {
        return new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-2.0f, (float)NoiseRouterData.m_224435_((float)0.05f)), Climate.Parameter.m_186822_((float)NoiseRouterData.m_224435_((float)0.05f), (float)NoiseRouterData.m_224435_((float)0.26666668f)), Climate.Parameter.m_186822_((float)NoiseRouterData.m_224435_((float)0.26666668f), (float)NoiseRouterData.m_224435_((float)0.4f)), Climate.Parameter.m_186822_((float)NoiseRouterData.m_224435_((float)0.4f), (float)NoiseRouterData.m_224435_((float)0.56666666f)), Climate.Parameter.m_186822_((float)NoiseRouterData.m_224435_((float)0.56666666f), (float)2.0f)};
    }

    @VisibleForDebug
    public Climate.Parameter[] getWeirdnessThresholds() {
        return new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-2.0f, (float)0.0f), Climate.Parameter.m_186822_((float)0.0f, (float)2.0f)};
    }
}

