/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.world.biome;

import com.ayutaki.chinjufumod.world.features.FeaturePlaced_CM;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class BiomeMaker_CM {
    @Nullable
    private static final Music NORMAL_MUSIC = null;

    protected static int calculateSkyColor(float f) {
        float $$1 = f / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static Biome biome(boolean flag, float temp, float downfall, MobSpawnSettings.Builder mobSpawn, BiomeGenerationSettings.Builder biomeGene, @Nullable Music bgm) {
        return BiomeMaker_CM.biome(flag, temp, downfall, 4159204, 329011, null, null, mobSpawn, biomeGene, bgm);
    }

    private static Biome biome(boolean flag, float temp, float downfall, int water, int fog, @Nullable Integer grass, @Nullable Integer foliage, MobSpawnSettings.Builder mobSpawn, BiomeGenerationSettings.Builder biomeGene, @Nullable Music bgm) {
        BiomeSpecialEffects.Builder biomespecialeffects$builder = new BiomeSpecialEffects.Builder().m_48034_(water).m_48037_(fog).m_48019_(12638463).m_48040_(BiomeMaker_CM.calculateSkyColor(temp)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(bgm);
        if (grass != null) {
            biomespecialeffects$builder.m_48045_(grass.intValue());
        }
        if (foliage != null) {
            biomespecialeffects$builder.m_48043_(foliage.intValue());
        }
        return new Biome.BiomeBuilder().m_264558_(flag).m_47609_(temp).m_47611_(downfall).m_47603_(biomespecialeffects$builder.m_48018_()).m_47605_(mobSpawn.m_48381_()).m_47601_(biomeGene.m_255380_()).m_47592_();
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder biomeSettings) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeSettings);
    }

    public static Biome makeSakuraBiome(HolderGetter<PlacedFeature> placedFeature, HolderGetter<ConfiguredWorldCarver<?>> worldCarver) {
        BiomeGenerationSettings.Builder biomeSettings = new BiomeGenerationSettings.Builder(placedFeature, worldCarver);
        BiomeMaker_CM.globalOverworldGeneration(biomeSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeSettings);
        biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.SAKURA_OAK_PLACE);
        biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.TAKENOKO_PLACE);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeSettings);
        MobSpawnSettings.Builder mobSpawn = new MobSpawnSettings.Builder();
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 12, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 100, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 95, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20530_, 5, 1, 1));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 100, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 100, 4, 4));
        mobSpawn.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
        Music music = Musics.m_263184_((Holder)SoundEvents.f_271257_);
        return BiomeMaker_CM.biome(true, 0.7f, 0.6f, mobSpawn, biomeSettings, music);
    }

    public static Biome makeSakuraHills(HolderGetter<PlacedFeature> placedFeature, HolderGetter<ConfiguredWorldCarver<?>> worldCarver) {
        BiomeGenerationSettings.Builder biomeSettings = new BiomeGenerationSettings.Builder(placedFeature, worldCarver);
        BiomeMaker_CM.globalOverworldGeneration(biomeSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeSettings);
        biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.SAKURA_OAK_HILLS_PLACE);
        biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.TAKENOKO_HILLS_PLACE);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeSettings);
        MobSpawnSettings.Builder mobSpawn = new MobSpawnSettings.Builder();
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 6, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 70, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 70, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20530_, 3, 1, 1));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 70, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 70, 4, 4));
        mobSpawn.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
        Music music = Musics.m_263184_((Holder)SoundEvents.f_271257_);
        return BiomeMaker_CM.biome(true, 0.7f, 0.6f, mobSpawn, biomeSettings, music);
    }

    public static Biome makeKaedeBiome(HolderGetter<PlacedFeature> placedFeature, HolderGetter<ConfiguredWorldCarver<?>> worldCarver, boolean bush) {
        BiomeGenerationSettings.Builder biomeSettings = new BiomeGenerationSettings.Builder(placedFeature, worldCarver);
        BiomeMaker_CM.globalOverworldGeneration(biomeSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeSettings);
        biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.KAEDE_AUTUMNOAK_PLACE);
        if (bush) {
            biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.KURIIGA_PLACE);
        }
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeSettings);
        MobSpawnSettings.Builder mobSpawn = new MobSpawnSettings.Builder();
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 1));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 100, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 95, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20530_, 5, 1, 1));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 100, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 50, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 10, 1, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 5, 1, 1));
        mobSpawn.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
        Music music = Musics.m_263184_((Holder)SoundEvents.f_283788_);
        return BiomeMaker_CM.biome(true, 0.7f, 0.6f, mobSpawn, biomeSettings, music);
    }

    public static Biome makeKaedeHills(HolderGetter<PlacedFeature> placedFeature, HolderGetter<ConfiguredWorldCarver<?>> worldCarver, boolean bush) {
        BiomeGenerationSettings.Builder biomeSettings = new BiomeGenerationSettings.Builder(placedFeature, worldCarver);
        BiomeMaker_CM.globalOverworldGeneration(biomeSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeSettings);
        biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.KAEDE_AUTUMNOAK_HILLS_PLACE);
        if (bush) {
            biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.KURIIGA_PLACE);
        }
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeSettings);
        MobSpawnSettings.Builder mobSpawn = new MobSpawnSettings.Builder();
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 5, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 1));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 2, 1, 2));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 70, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 70, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20530_, 3, 1, 1));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 70, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 35, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 7, 1, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 3, 1, 1));
        mobSpawn.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
        Music music = Musics.m_263184_((Holder)SoundEvents.f_283788_);
        return BiomeMaker_CM.biome(true, 0.7f, 0.6f, mobSpawn, biomeSettings, music);
    }

    public static Biome makeIchohBiome(HolderGetter<PlacedFeature> placedFeature, HolderGetter<ConfiguredWorldCarver<?>> worldCarver, boolean bush) {
        BiomeGenerationSettings.Builder biomeSettings = new BiomeGenerationSettings.Builder(placedFeature, worldCarver);
        BiomeMaker_CM.globalOverworldGeneration(biomeSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeSettings);
        biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.ICHOH_AUTUMNOAK_PLACE);
        if (bush) {
            biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.KURIIGA_PLACE);
        }
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeSettings);
        MobSpawnSettings.Builder mobSpawn = new MobSpawnSettings.Builder();
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20557_, 8, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20457_, 5, 2, 6));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 1, 1, 3));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20503_, 1, 1, 3));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 80, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20530_, 20, 1, 1));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 100, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 100, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 10, 1, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 20, 1, 1));
        mobSpawn.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
        Music music = Musics.m_263184_((Holder)SoundEvents.f_283788_);
        return BiomeMaker_CM.biome(true, 0.7f, 0.6f, mobSpawn, biomeSettings, music);
    }

    public static Biome makeIchohHills(HolderGetter<PlacedFeature> placedFeature, HolderGetter<ConfiguredWorldCarver<?>> worldCarver, boolean bush) {
        BiomeGenerationSettings.Builder biomeSettings = new BiomeGenerationSettings.Builder(placedFeature, worldCarver);
        BiomeMaker_CM.globalOverworldGeneration(biomeSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeSettings);
        biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.ICHOH_AUTUMNOAK_HILLS_PLACE);
        if (bush) {
            biomeSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, FeaturePlaced_CM.KURIIGA_PLACE);
        }
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeSettings);
        MobSpawnSettings.Builder mobSpawn = new MobSpawnSettings.Builder();
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20557_, 4, 4, 4));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20457_, 2, 2, 6));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 1, 1, 3));
        mobSpawn.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20503_, 1, 1, 3));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 56, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20530_, 14, 1, 1));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 70, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 70, 4, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 7, 1, 4));
        mobSpawn.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 14, 1, 1));
        mobSpawn.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
        Music music = Musics.m_263184_((Holder)SoundEvents.f_283788_);
        return BiomeMaker_CM.biome(true, 0.7f, 0.6f, mobSpawn, biomeSettings, music);
    }
}

