/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.managers;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.ByteBuffer;
import me.cortex.nvidium.NvidiumWorldRenderer;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.managers.RegionManager;
import me.cortex.nvidium.sodiumCompat.IRepackagedResult;
import me.cortex.nvidium.sodiumCompat.RepackagedSectionOutput;
import me.cortex.nvidium.util.BufferArena;
import me.cortex.nvidium.util.UploadingBufferStream;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.minecraft.core.SectionPos;
import org.joml.Vector3i;
import org.joml.Vector4i;
import org.lwjgl.system.MemoryUtil;

public class SectionManager {
    public static final int SECTION_SIZE = 32;
    private final RegionManager regionManager;
    private final Long2IntOpenHashMap section2id = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap section2terrain = new Long2IntOpenHashMap();
    public final UploadingBufferStream uploadStream;
    public final BufferArena terrainAreana;
    private final RenderDevice device;
    private final LongSet hiddenSectionKeys = new LongOpenHashSet();

    public SectionManager(RenderDevice device, long fallbackMemorySize, UploadingBufferStream uploadStream, int quadVertexSize, NvidiumWorldRenderer worldRenderer) {
        int maxRegions = 50000;
        this.device = device;
        this.uploadStream = uploadStream;
        this.terrainAreana = new BufferArena(device, fallbackMemorySize, quadVertexSize);
        this.regionManager = new RegionManager(device, maxRegions, maxRegions * 200, uploadStream, worldRenderer::enqueueRegionSort);
        this.section2id.defaultReturnValue(-1);
        this.section2terrain.defaultReturnValue(-1);
    }

    public void uploadChunkBuildResult(ChunkBuildOutput result) {
        RepackagedSectionOutput output = ((IRepackagedResult)result).getOutput();
        RenderSection section = result.render;
        long sectionKey = SectionPos.m_123209_((int)section.getChunkX(), (int)section.getChunkY(), (int)section.getChunkZ());
        if (output == null || output.quads() == 0) {
            this.deleteSection(sectionKey);
            return;
        }
        int sectionIdx = this.section2id.computeIfAbsent(sectionKey, key -> this.regionManager.allocateSection(SectionPos.m_123213_((long)key), SectionPos.m_123225_((long)key), SectionPos.m_123230_((long)key)));
        int terrainAddress = this.section2terrain.get(sectionKey);
        if (terrainAddress != -1 && !this.terrainAreana.canReuse(terrainAddress, output.quads())) {
            this.section2terrain.remove(sectionKey);
            this.terrainAreana.free(terrainAddress);
            terrainAddress = -1;
        }
        if (terrainAddress == -1) {
            terrainAddress = this.terrainAreana.allocQuads(output.quads());
        }
        this.section2terrain.put(sectionKey, terrainAddress);
        long geometryUpload = this.terrainAreana.upload(this.uploadStream, terrainAddress);
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)output.geometry().getDirectBuffer()), (long)geometryUpload, (long)output.geometry().getLength());
        long metadata = this.regionManager.setSectionData(sectionIdx);
        boolean hideSectionBitSet = this.hiddenSectionKeys.contains(sectionKey);
        Vector3i min = output.min();
        Vector3i size = output.size();
        int px = section.getChunkX() << 8 | size.x << 4 | min.x;
        int py = (section.getChunkY() & 0x1FF) << 8 | size.y << 4 | min.y | (hideSectionBitSet ? 131072 : 0) | this.regionManager.getSectionRefId(sectionIdx) << 18;
        int pz = section.getChunkZ() << 8 | size.z << 4 | min.z;
        int pw = terrainAddress;
        new Vector4i(px, py, pz, pw).getToAddress(metadata);
        metadata += 16L;
        for (int i = 0; i < 4; ++i) {
            int geo = Short.toUnsignedInt(output.offsets()[i * 2]) | Short.toUnsignedInt(output.offsets()[i * 2 + 1]) << 16;
            MemoryUtil.memPutInt((long)metadata, (int)geo);
            metadata += 4L;
        }
    }

    public void setHideBit(int x, int y, int z, boolean hide) {
        long sectionKey = SectionPos.m_123209_((int)x, (int)y, (int)z);
        if (hide ? !this.hiddenSectionKeys.add(sectionKey) : !this.hiddenSectionKeys.remove(sectionKey)) {
            return;
        }
        int sectionId = this.section2id.get(sectionKey);
        if (sectionId != -1) {
            long metadata = this.regionManager.setSectionData(sectionId);
            MemoryUtil.memPutInt((long)(metadata + 4L), (int)(MemoryUtil.memGetInt((long)(metadata + 4L)) & 0xFFFDFFFF | (hide ? 1 : 0) << 17));
        }
    }

    public void deleteSection(RenderSection section) {
        this.deleteSection(SectionPos.m_123209_((int)section.getChunkX(), (int)section.getChunkY(), (int)section.getChunkZ()));
    }

    private void deleteSection(long sectionKey) {
        int sectionIdx = this.section2id.remove(sectionKey);
        if (sectionIdx != -1) {
            this.terrainAreana.free(this.section2terrain.remove(sectionKey));
            this.regionManager.removeSection(sectionIdx);
        }
    }

    public void destroy() {
        this.regionManager.destroy();
        this.terrainAreana.delete();
    }

    public void commitChanges() {
        this.regionManager.commitChanges();
    }

    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    public void removeRegionById(int regionId) {
        if (!this.regionManager.regionExists(regionId)) {
            return;
        }
        long rk = this.regionManager.regionIdToKey(regionId);
        int X = SectionPos.m_123213_((long)rk) << 3;
        int Y = SectionPos.m_123225_((long)rk) << 2;
        int Z = SectionPos.m_123230_((long)rk) << 3;
        for (int x = X; x < X + 8; ++x) {
            for (int y = Y; y < Y + 4; ++y) {
                for (int z = Z; z < Z + 8; ++z) {
                    this.deleteSection(SectionPos.m_123209_((int)x, (int)y, (int)z));
                }
            }
        }
    }
}

