/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.eureka.blockentity;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.eureka.EurekaBlockEntities;
import org.valkyrienskies.eureka.EurekaConfig;
import org.valkyrienskies.eureka.EurekaProperties;
import org.valkyrienskies.eureka.gui.engine.EngineScreenMenu;
import org.valkyrienskies.eureka.registry.FuelRegistry;
import org.valkyrienskies.eureka.ship.EurekaShipControl;
import org.valkyrienskies.eureka.util.ContainerDataDelegate;
import org.valkyrienskies.eureka.util.KtContainerData;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010j\u001a\u00020i\u0012\u0006\u0010l\u001a\u00020k\u00a2\u0006\u0004\bm\u0010nJ\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0010J\u0017\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0017\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001cH\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b!\u0010\u001fJ\u000f\u0010\"\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\"\u0010\u0010J\u000f\u0010#\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010\u0015J\u000f\u0010$\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b$\u0010\u0013J\u0017\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010*\u001a\u00020&2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010,\u001a\u00020&2\u0006\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b,\u0010(J\u001f\u0010.\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010-\u001a\u00020&H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00102\u001a\u00020\u00112\u0006\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00107\u001a\u0002062\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b7\u00108J)\u0010<\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020&2\b\u0010;\u001a\u0004\u0018\u000104H\u0016\u00a2\u0006\u0004\b<\u0010=J'\u0010>\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u00042\u0006\u0010-\u001a\u00020&2\u0006\u0010;\u001a\u000204H\u0016\u00a2\u0006\u0004\b>\u0010=J\u001f\u0010?\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u00042\u0006\u0010-\u001a\u00020&H\u0016\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010C\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020AH\u0016\u00a2\u0006\u0004\bC\u0010DR\u001c\u0010I\u001a\u0004\u0018\u00010E8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\bH\u0010\u0010\u001a\u0004\bF\u0010GR\u0017\u0010K\u001a\u00020J8\u0006\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010NR+\u0010U\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010\u0015\"\u0004\bS\u0010TR+\u0010Y\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bV\u0010Q\u001a\u0004\bW\u0010\u0015\"\u0004\bX\u0010TR+\u0010]\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bZ\u0010Q\u001a\u0004\b[\u0010\u0015\"\u0004\b\\\u0010TR\"\u0010^\u001a\u00020&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010_\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u0016\u0010d\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bd\u0010eR\u0016\u0010f\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010gR\u0016\u0010h\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010e\u00a8\u0006o"}, d2={"Lorg/valkyrienskies/eureka/blockentity/EngineBlockEntity;", "Lnet/minecraft/world/level/block/entity/BaseContainerBlockEntity;", "Lnet/minecraft/world/inventory/StackedContentsCompatible;", "Lnet/minecraft/world/WorldlyContainer;", "", "containerId", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "createMenu", "(ILnet/minecraft/world/entity/player/Inventory;)Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/network/chat/Component;", "getDefaultName", "()Lnet/minecraft/network/chat/Component;", "", "tick", "()V", "", "isBurning", "()Z", "getScaledFuel", "()I", "consumeFuel", "", "value", "scaleEngineHeating", "(F)F", "scaleEngineCooling", "Lnet/minecraft/nbt/CompoundTag;", "tag", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;)V", "compoundTag", "load", "clearContent", "getContainerSize", "isEmpty", "slot", "Lnet/minecraft/world/item/ItemStack;", "getItem", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeItem", "(II)Lnet/minecraft/world/item/ItemStack;", "removeItemNoUpdate", "stack", "setItem", "(ILnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/core/Direction;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "index", "itemStack", "direction", "canPlaceItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "canTakeItemThroughFace", "canPlaceItem", "(ILnet/minecraft/world/item/ItemStack;)Z", "Lnet/minecraft/world/entity/player/StackedContents;", "helper", "fillStackedContents", "(Lnet/minecraft/world/entity/player/StackedContents;)V", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "getShip", "()Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "getShip$annotations", "ship", "Lorg/valkyrienskies/eureka/util/KtContainerData;", "data", "Lorg/valkyrienskies/eureka/util/KtContainerData;", "getData", "()Lorg/valkyrienskies/eureka/util/KtContainerData;", "<set-?>", "heatLevel$delegate", "Lorg/valkyrienskies/eureka/util/ContainerDataDelegate;", "getHeatLevel", "setHeatLevel", "(I)V", "heatLevel", "fuelLeft$delegate", "getFuelLeft", "setFuelLeft", "fuelLeft", "fuelTotal$delegate", "getFuelTotal", "setFuelTotal", "fuelTotal", "fuel", "Lnet/minecraft/world/item/ItemStack;", "getFuel", "()Lnet/minecraft/world/item/ItemStack;", "setFuel", "(Lnet/minecraft/world/item/ItemStack;)V", "maxEffectiveFuel", "F", "lastFuelValue", "I", "heat", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "eureka-1201"})
public final class EngineBlockEntity
extends BaseContainerBlockEntity
implements StackedContentsCompatible,
WorldlyContainer {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final KtContainerData data;
    @NotNull
    private final ContainerDataDelegate heatLevel$delegate;
    @NotNull
    private final ContainerDataDelegate fuelLeft$delegate;
    @NotNull
    private final ContainerDataDelegate fuelTotal$delegate;
    @NotNull
    private ItemStack fuel;
    private float maxEffectiveFuel;
    private int lastFuelValue;
    private float heat;

    public EngineBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(EurekaBlockEntities.INSTANCE.getENGINE().get(), pos, state);
        this.data = new KtContainerData();
        this.heatLevel$delegate = this.data.provideDelegate((Object)this, $$delegatedProperties[0]);
        this.fuelLeft$delegate = this.data.provideDelegate((Object)this, $$delegatedProperties[1]);
        this.fuelTotal$delegate = this.data.provideDelegate((Object)this, $$delegatedProperties[2]);
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.fuel = itemStack;
        this.maxEffectiveFuel = 100.0f - EurekaConfig.SERVER.getEngineHeatGain();
        this.lastFuelValue = 1600;
    }

    private final LoadedServerShip getShip() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
    }

    private static /* synthetic */ void getShip$annotations() {
    }

    @NotNull
    public final KtContainerData getData() {
        return this.data;
    }

    private final int getHeatLevel() {
        return this.heatLevel$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setHeatLevel(int n) {
        this.heatLevel$delegate.setValue((Object)this, $$delegatedProperties[0], n);
    }

    private final int getFuelLeft() {
        return this.fuelLeft$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setFuelLeft(int n) {
        this.fuelLeft$delegate.setValue((Object)this, $$delegatedProperties[1], n);
    }

    private final int getFuelTotal() {
        return this.fuelTotal$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setFuelTotal(int n) {
        this.fuelTotal$delegate.setValue((Object)this, $$delegatedProperties[2], n);
    }

    @NotNull
    public final ItemStack getFuel() {
        return this.fuel;
    }

    public final void setFuel(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.fuel = itemStack;
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        return new EngineScreenMenu(containerId, inventory, this);
    }

    @NotNull
    protected Component m_6820_() {
        MutableComponent mutableComponent = Component.m_237115_((String)"gui.vs_eureka.engine");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    public final void tick() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        boolean isPowered = level2.m_276867_(this.m_58899_());
        if (EurekaConfig.SERVER.getEngineRedstoneBehaviorPause() && isPowered) {
            return;
        }
        if (!isPowered) {
            if (this.getFuelLeft() > 0) {
                if (EurekaConfig.SERVER.getEngineFuelSaving()) {
                    if (this.heat <= this.maxEffectiveFuel) {
                        this.heat += this.scaleEngineHeating(EurekaConfig.SERVER.getEngineHeatGain());
                        var2_2 = this.getFuelLeft();
                        this.setFuelLeft(var2_2 + -1);
                    }
                } else {
                    var2_2 = this.getFuelLeft();
                    this.setFuelLeft(var2_2 + -1);
                    if (this.heat <= this.maxEffectiveFuel) {
                        this.heat += this.scaleEngineHeating(EurekaConfig.SERVER.getEngineHeatGain());
                    }
                }
                if (!this.fuel.m_41619_() && this.lastFuelValue <= EurekaConfig.SERVER.getEngineMinCapacity() - this.getFuelLeft()) {
                    this.consumeFuel();
                }
            } else if (!this.fuel.m_41619_()) {
                this.consumeFuel();
            }
        }
        int prevHeatLevel = this.getHeatLevel();
        this.setHeatLevel(org.joml.Math.min((int)((int)Math.ceil(this.heat * 4.0f / 100.0f)), (int)4));
        if (prevHeatLevel != this.getHeatLevel()) {
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            level3.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)EurekaProperties.INSTANCE.getHEAT(), (Comparable)Integer.valueOf(this.getHeatLevel())), 11);
        }
        if (this.heat > 0.0f) {
            EurekaShipControl eurekaShipControl;
            LoadedServerShip loadedServerShip = this.getShip();
            EurekaShipControl eurekaShipControl2 = eurekaShipControl = loadedServerShip != null ? (EurekaShipControl)loadedServerShip.getAttachment(EurekaShipControl.class) : null;
            if (this.getShip() != null && eurekaShipControl != null) {
                float effectiveHeat = 1.0f;
                if (this.heat < this.maxEffectiveFuel) {
                    effectiveHeat = this.heat / 100.0f;
                }
                eurekaShipControl.setPowerLinear(eurekaShipControl.getPowerLinear() + (double)org.joml.Math.lerp((float)EurekaConfig.SERVER.getEnginePowerLinearMin(), (float)EurekaConfig.SERVER.getEnginePowerLinear(), (float)effectiveHeat));
                eurekaShipControl.setPowerAngular(eurekaShipControl.getPowerAngular() + (double)org.joml.Math.lerp((float)EurekaConfig.SERVER.getEnginePowerAngularMin(), (float)EurekaConfig.SERVER.getEnginePowerAngular(), (float)effectiveHeat));
                this.heat -= eurekaShipControl.getConsumed();
            }
            this.heat = Math.max(this.heat - this.scaleEngineCooling(EurekaConfig.SERVER.getEngineHeatLoss()), 0.0f);
        }
    }

    public final boolean isBurning() {
        return this.getFuelLeft() > 0;
    }

    private final int getScaledFuel() {
        return (int)((float)FuelRegistry.INSTANCE.get(this.fuel) * EurekaConfig.SERVER.getEngineFuelMultiplier());
    }

    private final void consumeFuel() {
        this.lastFuelValue = this.getScaledFuel();
        if (this.lastFuelValue > 0) {
            if (this.getFuelLeft() > 0 && this.lastFuelValue > EurekaConfig.SERVER.getEngineMinCapacity() - this.getFuelLeft()) {
                return;
            }
            this.setFuelLeft(this.getFuelLeft() + this.lastFuelValue);
            this.setFuelTotal(Math.max(this.lastFuelValue, EurekaConfig.SERVER.getEngineMinCapacity()));
            if (this.fuel.m_41720_().m_41470_()) {
                Item item = this.fuel.m_41720_().m_41469_();
                Intrinsics.checkNotNull((Object)item);
                this.fuel = new ItemStack((ItemLike)item, 1);
            } else {
                this.m_7407_(0, 1);
            }
            this.m_6596_();
        }
    }

    private final float scaleEngineHeating(float value) {
        return ((float)100 * EurekaConfig.SERVER.getEngineHeatChangeExponent() - this.heat * EurekaConfig.SERVER.getEngineHeatChangeExponent() + 1.0f) * value;
    }

    private final float scaleEngineCooling(float value) {
        return (this.heat * EurekaConfig.SERVER.getEngineHeatChangeExponent() + 1.0f) * value;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128365_("FuelSlot", (Tag)this.fuel.m_41739_(new CompoundTag()));
        tag.m_128405_("FuelLeft", this.getFuelLeft());
        tag.m_128405_("PrevFuelTotal", this.getFuelTotal());
        tag.m_128350_("Heat", this.heat);
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        this.fuel = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("FuelSlot"));
        this.setFuelLeft(compoundTag.m_128451_("FuelLeft"));
        this.setFuelTotal(compoundTag.m_128451_("PrevFuelTotal"));
        this.heat = compoundTag.m_128457_("Heat");
        super.m_142466_(compoundTag);
    }

    public void m_6211_() {
        this.fuel = ItemStack.f_41583_;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.fuel.m_41619_();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        ItemStack itemStack;
        if (slot == 0) {
            itemStack = this.fuel;
        } else {
            ItemStack itemStack2 = ItemStack.f_41583_;
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        }
        return itemStack;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_((List)CollectionsKt.listOf((Object)this.fuel), (int)slot, (int)amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        if (slot == 0) {
            this.fuel = ItemStack.f_41583_;
        }
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (slot == 0) {
            this.fuel = stack;
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        return level.m_7702_(this.f_58858_) != this ? false : player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public int[] m_7071_(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        int[] nArray = new int[]{0};
        return nArray;
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return direction != Direction.DOWN && this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return index == 0 && direction == Direction.DOWN && !this.fuel.m_41619_() && FuelRegistry.INSTANCE.get(this.fuel) <= 0;
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return index == 0 && FuelRegistry.INSTANCE.get(stack) > 0;
    }

    public void m_5809_(@NotNull StackedContents helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        helper.m_36491_(this.fuel);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(EngineBlockEntity.class, "heatLevel", "getHeatLevel()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(EngineBlockEntity.class, "fuelLeft", "getFuelLeft()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(EngineBlockEntity.class, "fuelTotal", "getFuelTotal()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

