/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.eureka.ship;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Matrix3dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.attachment.AttachmentHolder;
import org.valkyrienskies.core.api.events.ShipLoadEvent;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerTickListener;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.eureka.EurekaConfig;
import org.valkyrienskies.eureka.ship.StabilizeKt;
import org.valkyrienskies.mod.api.SeatedControllingPlayer;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0017\b\u0007\u0018\u0000 w2\u00020\u00012\u00020\u0002:\u0002xwB\u0007\u00a2\u0006\u0004\bv\u0010\u001fJ\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b \u0010\u001fJ'\u0010!\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b!\u0010$J\u001f\u0010%\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010'\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b'\u0010&J\u000f\u0010(\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b(\u0010\u001fR$\u0010*\u001a\u0004\u0018\u00010)8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0016\u00100\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00101R\"\u00104\u001a\u0002038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\"\u0010:\u001a\u0002038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u00105\u001a\u0004\b;\u00107\"\u0004\b<\u00109R\u0016\u0010>\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010A\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u00107R\u0016\u0010B\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u00101R\u0016\u0010C\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0011\u0010F\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\bE\u00107R$\u0010H\u001a\u00020=2\u0006\u0010G\u001a\u00020=8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bH\u0010?\u001a\u0004\bI\u0010JR\u0016\u0010K\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u00105R\"\u0010L\u001a\u0002038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bL\u00105\u001a\u0004\bL\u00107\"\u0004\bM\u00109R\u0018\u0010N\u001a\u0004\u0018\u00010\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010OR$\u0010Q\u001a\u0004\u0018\u00010P8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\"\u0010W\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bW\u00101\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\"\u0010\\\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\\\u00101\u001a\u0004\b]\u0010Y\"\u0004\b^\u0010[R\"\u0010_\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b_\u00101\u001a\u0004\b`\u0010Y\"\u0004\ba\u0010[R*\u0010d\u001a\u00020b2\u0006\u0010c\u001a\u00020b8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bd\u0010e\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\"\u0010j\u001a\u00020b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bj\u0010e\u001a\u0004\bk\u0010g\"\u0004\bl\u0010iR*\u0010m\u001a\u00020b2\u0006\u0010c\u001a\u00020b8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bm\u0010e\u001a\u0004\bn\u0010g\"\u0004\bo\u0010iR*\u0010p\u001a\u00020b2\u0006\u0010c\u001a\u00020b8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bp\u0010e\u001a\u0004\bq\u0010g\"\u0004\br\u0010iR*\u0010s\u001a\u00020b2\u0006\u0010c\u001a\u00020b8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bs\u0010e\u001a\u0004\bt\u0010g\"\u0004\bu\u0010i\u00a8\u0006y"}, d2={"Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/ServerTickListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lorg/valkyrienskies/mod/api/SeatedControllingPlayer;", "player", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "getControlData", "(Lorg/valkyrienskies/mod/api/SeatedControllingPlayer;)Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "control", "applyPlayerControl", "(Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;Lorg/valkyrienskies/core/api/ships/PhysShip;)V", "Lorg/joml/Matrix3dc;", "moiTensor", "", "strength", "Lorg/joml/Vector3d;", "getPlayerControlledBanking", "(Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/joml/Matrix3dc;D)Lorg/joml/Vector3d;", "getPlayerForwardVel", "(Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;Lorg/valkyrienskies/core/api/ships/PhysShip;)Lorg/joml/Vector3d;", "mass", "getPlayerUpwardVel", "(Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;D)Lorg/joml/Vector3d;", "showCruiseStatus", "()V", "deleteIfEmpty", "smoothing", "max", "x", "(DDD)D", "smoothingATan", "(DD)D", "smoothingATanMax", "onServerTick", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "getShip$eureka_1201", "()Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "setShip$eureka_1201", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)V", "extraForceLinear", "D", "extraForceAngular", "", "aligning", "Z", "getAligning", "()Z", "setAligning", "(Z)V", "disassembling", "getDisassembling", "setDisassembling", "", "physConsumption", "F", "getAnchored", "anchored", "angleUntilAligned", "positionUntilAligned", "Lorg/joml/Vector3d;", "getCanDisassemble", "canDisassemble", "value", "consumed", "getConsumed", "()F", "wasCruisePressed", "isCruising", "setCruising", "controlData", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "Lnet/minecraft/world/entity/player/Player;", "seatedPlayer", "Lnet/minecraft/world/entity/player/Player;", "getSeatedPlayer", "()Lnet/minecraft/world/entity/player/Player;", "setSeatedPlayer", "(Lnet/minecraft/world/entity/player/Player;)V", "oldSpeed", "getOldSpeed", "()D", "setOldSpeed", "(D)V", "powerLinear", "getPowerLinear", "setPowerLinear", "powerAngular", "getPowerAngular", "setPowerAngular", "", "v", "anchors", "I", "getAnchors", "()I", "setAnchors", "(I)V", "anchorsActive", "getAnchorsActive", "setAnchorsActive", "balloons", "getBalloons", "setBalloons", "helms", "getHelms", "setHelms", "floaters", "getFloaters", "setFloaters", "<init>", "Companion", "ControlData", "eureka-1201"})
@SourceDebugExtension(value={"SMAP\nEurekaShipControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EurekaShipControl.kt\norg/valkyrienskies/eureka/ship/EurekaShipControl\n+ 2 AttachmentHolder.kt\norg/valkyrienskies/core/api/attachment/AttachmentHolderKt\n*L\n1#1,439:1\n80#2:440\n*S KotlinDebug\n*F\n+ 1 EurekaShipControl.kt\norg/valkyrienskies/eureka/ship/EurekaShipControl\n*L\n386#1:440\n*E\n"})
public final class EurekaShipControl
implements ShipPhysicsListener,
ServerTickListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonIgnore
    @Nullable
    private LoadedServerShip ship;
    private double extraForceLinear;
    private double extraForceAngular;
    private boolean aligning;
    private boolean disassembling;
    private float physConsumption;
    private double angleUntilAligned;
    @NotNull
    private Vector3d positionUntilAligned = new Vector3d();
    private float consumed;
    private boolean wasCruisePressed;
    @JsonProperty(value="cruise")
    private boolean isCruising;
    @Nullable
    private ControlData controlData;
    @JsonIgnore
    @Nullable
    private Player seatedPlayer;
    @JsonIgnore
    private double oldSpeed;
    private double powerLinear;
    private double powerAngular;
    private int anchors;
    private int anchorsActive;
    private int balloons;
    private int helms;
    private int floaters;
    private static final double ALIGN_THRESHOLD = 0.01;
    private static final double DISASSEMBLE_THRESHOLD = 0.02;
    private static final double GRAVITY = -10.0;

    @Nullable
    public final LoadedServerShip getShip$eureka_1201() {
        return this.ship;
    }

    public final void setShip$eureka_1201(@Nullable LoadedServerShip loadedServerShip) {
        this.ship = loadedServerShip;
    }

    public final boolean getAligning() {
        return this.aligning;
    }

    public final void setAligning(boolean bl) {
        this.aligning = bl;
    }

    public final boolean getDisassembling() {
        return this.disassembling;
    }

    public final void setDisassembling(boolean bl) {
        this.disassembling = bl;
    }

    private final boolean getAnchored() {
        return this.anchorsActive > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getCanDisassemble() {
        if (this.ship == null) return false;
        if (!this.disassembling) return false;
        if (!(Math.abs(this.angleUntilAligned) < 0.02)) return false;
        LoadedServerShip loadedServerShip = this.ship;
        Intrinsics.checkNotNull((Object)loadedServerShip);
        if (!(this.positionUntilAligned.distanceSquared(loadedServerShip.getTransform().getPositionInWorld()) < 4.0)) return false;
        return true;
    }

    public final float getConsumed() {
        return this.consumed;
    }

    public final boolean isCruising() {
        return this.isCruising;
    }

    public final void setCruising(boolean bl) {
        this.isCruising = bl;
    }

    @Nullable
    public final Player getSeatedPlayer() {
        return this.seatedPlayer;
    }

    public final void setSeatedPlayer(@Nullable Player player) {
        this.seatedPlayer = player;
    }

    public final double getOldSpeed() {
        return this.oldSpeed;
    }

    public final void setOldSpeed(double d) {
        this.oldSpeed = d;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        SeatedControllingPlayer controllingPlayer;
        boolean validPlayer;
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        if (this.helms < 1) {
            physShip.setDoFluidDrag(true);
            return;
        }
        physShip.setDoFluidDrag(EurekaConfig.SERVER.getDoFluidDrag());
        LoadedServerShip loadedServerShip = this.ship;
        if (loadedServerShip == null) {
            return;
        }
        LoadedServerShip ship = loadedServerShip;
        double mass = physShip.getMass();
        Matrix3dc moiTensor = physShip.getMomentOfInertia();
        Vector3dc omega = physShip.getOmega();
        Vector3dc vel = physShip.getVelocity();
        double balloonForceProvided = (double)this.balloons * EurekaShipControl.Companion.getForcePerBalloon();
        if (EurekaConfig.SERVER.getMaxBalloonsPerEngine() > 0) {
            balloonForceProvided *= Math.min(1.0, this.extraForceLinear * (double)EurekaConfig.SERVER.getMaxBalloonsPerEngine() / (double)(EurekaConfig.SERVER.getEnginePowerLinear() * (float)this.balloons));
        }
        double buoyantFactorPerFloater = Math.min(EurekaConfig.SERVER.getFloaterBuoyantFactorPerKg() / 15.0 / mass, EurekaConfig.SERVER.getMaxFloaterBuoyantFactor());
        physShip.setBuoyantFactor(1.0 + (double)this.floaters * buoyantFactorPerFloater);
        Quaterniond invRotation = physShip.getTransform().getShipToWorldRotation().invert(new Quaterniond());
        AxisAngle4d invRotationAxisAngle = new AxisAngle4d((Quaterniondc)invRotation);
        int alignTarget = (int)Math.floor(invRotationAxisAngle.angle / 1.5707963267948966 + 4.5) % 4;
        this.angleUntilAligned = (double)alignTarget * 1.5707963267948966 - invRotationAxisAngle.angle;
        if (this.disassembling) {
            Vector3dc pos = ship.getTransform().getPositionInWorld();
            this.positionUntilAligned = pos.floor(new Vector3d());
            Vector3d direction = pos.sub((Vector3dc)this.positionUntilAligned, new Vector3d());
            Intrinsics.checkNotNull((Object)direction);
            physShip.applyInvariantForce((Vector3dc)direction);
        }
        if (this.aligning && Math.abs(this.angleUntilAligned) > 0.01) {
            if (this.angleUntilAligned < 0.3 && this.angleUntilAligned > 0.0) {
                this.angleUntilAligned = 0.3;
            }
            if (this.angleUntilAligned > -0.3 && this.angleUntilAligned < 0.0) {
                this.angleUntilAligned = -0.3;
            }
            Vector3d idealOmega = new Vector3d(invRotationAxisAngle.x, invRotationAxisAngle.y, invRotationAxisAngle.z).mul(-this.angleUntilAligned).mul(EurekaConfig.SERVER.getStabilizationSpeed());
            Vector3d idealTorque = moiTensor.transform(idealOmega);
            Intrinsics.checkNotNull((Object)idealTorque);
            physShip.applyInvariantTorque((Vector3dc)idealTorque);
        }
        boolean bl = validPlayer = (controllingPlayer = (SeatedControllingPlayer)ship.getAttachment(SeatedControllingPlayer.class)) != null && !this.getAnchored();
        if (this.getAnchored()) {
            if (this.isCruising) {
                this.isCruising = false;
                this.showCruiseStatus();
            }
            physShip.setStatic(true);
            return;
        }
        StabilizeKt.stabilize(physShip, omega, vel, physShip, !validPlayer && !this.aligning, !validPlayer);
        Vector3d idealUpwardVel = null;
        idealUpwardVel = new Vector3d(0.0, 0.0, 0.0);
        if (validPlayer) {
            SeatedControllingPlayer seatedControllingPlayer = controllingPlayer;
            Intrinsics.checkNotNull((Object)seatedControllingPlayer);
            SeatedControllingPlayer player = seatedControllingPlayer;
            ControlData currentControlData = this.getControlData(player);
            if (!this.isCruising) {
                this.controlData = currentControlData;
            }
            this.wasCruisePressed = player.getCruise();
        } else if (!this.isCruising) {
            this.controlData = null;
            this.oldSpeed = 0.0;
        }
        ControlData controlData = this.controlData;
        if (controlData != null) {
            ControlData control = controlData;
            boolean bl2 = false;
            this.applyPlayerControl(control, physShip);
            idealUpwardVel = this.getPlayerUpwardVel(control, mass);
        }
        double idealUpwardForce = (idealUpwardVel.y() - vel.y() - -10.0 / EurekaConfig.SERVER.getElevationSnappiness()) * mass * EurekaConfig.SERVER.getElevationSnappiness();
        physShip.applyInvariantForce((Vector3dc)new Vector3d(0.0, Math.min(balloonForceProvided, Math.max(idealUpwardForce, 0.0)) + vel.y() * -mass, 0.0));
        physShip.setStatic(this.getAnchored());
    }

    private final ControlData getControlData(SeatedControllingPlayer player) {
        ControlData currentControlData = ControlData.Companion.create(player);
        if (!this.wasCruisePressed && player.getCruise()) {
            this.isCruising = !this.isCruising;
            this.showCruiseStatus();
        } else if (!(player.getCruise() || !this.isCruising || player.getLeftImpulse() == 0.0f && !player.getSprintOn() && player.getUpImpulse() == 0.0f && player.getForwardImpulse() == 0.0f || Intrinsics.areEqual((Object)currentControlData, (Object)this.controlData))) {
            this.isCruising = false;
            this.showCruiseStatus();
        }
        return currentControlData;
    }

    private final void applyPlayerControl(ControlData control, PhysShip physShip) {
        boolean isBelowMaxTurnSpeed;
        LoadedServerShip loadedServerShip = this.ship;
        if (loadedServerShip == null) {
            return;
        }
        LoadedServerShip ship = loadedServerShip;
        ShipTransform transform = physShip.getTransform();
        AABBdc aabb = ship.getWorldAABB();
        Vector3dc center = transform.getPositionInWorld();
        Matrix3dc moiTensor = physShip.getMomentOfInertia();
        Vector3dc omega = physShip.getOmega();
        EurekaShipControl $this$applyPlayerControl_u24lambda_u241 = this;
        boolean bl = false;
        double dist = center.distance(aabb.minX(), center.y(), aabb.minZ());
        dist = Math.max(dist, center.distance(aabb.minX(), center.y(), aabb.maxZ()));
        dist = Math.max(dist, center.distance(aabb.maxX(), center.y(), aabb.minZ()));
        dist = Math.max(dist, center.distance(aabb.maxX(), center.y(), aabb.maxZ()));
        double largestDistance = RangesKt.coerceIn((double)dist, (double)0.5, (double)EurekaConfig.SERVER.getMaxSizeForTurnSpeedPenalty());
        double maxLinearAcceleration = EurekaConfig.SERVER.getTurnAcceleration();
        double maxLinearSpeed = EurekaConfig.SERVER.getTurnSpeed() + this.extraForceAngular;
        double maxOmegaY = maxLinearSpeed / largestDistance;
        double maxAlphaY = maxLinearAcceleration / largestDistance;
        boolean bl2 = isBelowMaxTurnSpeed = Math.abs(omega.y()) < maxOmegaY;
        double normalizedAlphaYMultiplier = isBelowMaxTurnSpeed && !(control.getLeftImpulse() == 0.0f) ? (double)control.getLeftImpulse() : -RangesKt.coerceIn((double)omega.y(), (double)-1.0, (double)1.0);
        double idealAlphaY = normalizedAlphaYMultiplier * maxAlphaY;
        Vector3d vector3d = moiTensor.transform(new Vector3d(0.0, idealAlphaY, 0.0));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transform(...)");
        physShip.applyInvariantTorque((Vector3dc)vector3d);
        physShip.applyInvariantTorque((Vector3dc)this.getPlayerControlledBanking(control, physShip, moiTensor, -idealAlphaY));
        physShip.applyInvariantForce((Vector3dc)this.getPlayerForwardVel(control, physShip));
    }

    private final Vector3d getPlayerControlledBanking(ControlData control, PhysShip physShip, Matrix3dc moiTensor, double strength) {
        Vec3i vec3i = control.getSeatInDirection().m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vector3d rotationVector = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
        physShip.getTransform().getShipToWorldRotation().transform(rotationVector);
        rotationVector.y = 0.0;
        rotationVector.mul(strength * 1.5);
        physShip.getTransform().getShipToWorldRotation().transform(moiTensor.transform(physShip.getTransform().getShipToWorldRotation().transformInverse(rotationVector)));
        return rotationVector;
    }

    private final Vector3d getPlayerForwardVel(ControlData control, PhysShip physShip) {
        double scaledMass = physShip.getMass() * EurekaConfig.SERVER.getSpeedMassScale();
        Vector3dc vel = physShip.getVelocity();
        Vec3i vec3i = control.getSeatInDirection().m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vector3d forwardVector = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
        physShip.getTransform().getShipToWorldRotation().transform(forwardVector);
        forwardVector.normalize();
        double s = 1.0 / this.smoothingATanMax(EurekaConfig.SERVER.getLinearMaxMass(), physShip.getMass() * EurekaConfig.SERVER.getLinearMassScaling() + EurekaConfig.SERVER.getLinearBaseMass());
        this.oldSpeed = this.oldSpeed * (1.0 - s) + (double)control.getForwardImpulse() * s;
        double speed = this.oldSpeed * EurekaConfig.SERVER.getLinearCasualSpeed() / (double)3;
        if (!(this.extraForceLinear == 0.0)) {
            double boost = Math.max((this.extraForceLinear - (double)EurekaConfig.SERVER.getEnginePowerLinear() * EurekaConfig.SERVER.getEngineBoostOffset()) * EurekaConfig.SERVER.getEngineBoost(), 0.0);
            this.extraForceLinear += boost + boost * boost * EurekaConfig.SERVER.getEngineBoostExponentialPower();
            this.extraForceLinear /= scaledMass;
            speed += speed < 0.0 ? this.smoothingATanMax(EurekaConfig.SERVER.getMaxReverseSpeedFromEngines(), this.extraForceLinear * this.oldSpeed) : this.smoothingATanMax(EurekaConfig.SERVER.getMaxSpeedFromEngines(), this.extraForceLinear * this.oldSpeed);
        }
        forwardVector.mul(speed);
        Vector3d playerUpDirection = physShip.getTransform().getShipToWorldRotation().transform(new Vector3d(0.0, 1.0, 0.0));
        Vector3d velOrthogonalToPlayerUp = vel.sub((Vector3dc)playerUpDirection.mul(playerUpDirection.dot(vel)), new Vector3d());
        Vector3d baseForwardVel = forwardVector.mul(EurekaConfig.SERVER.getBaseSpeed());
        Vector3d forwardForce = baseForwardVel.sub((Vector3dc)velOrthogonalToPlayerUp).mul(scaledMass);
        Intrinsics.checkNotNull((Object)forwardForce);
        return forwardForce;
    }

    private final Vector3d getPlayerUpwardVel(ControlData control, double mass) {
        if (!(control.getUpImpulse() == 0.0f)) {
            double balloonForceProvided = (double)this.balloons * EurekaShipControl.Companion.getForcePerBalloon();
            Vector3d vector3d = new Vector3d(0.0, 1.0, 0.0).mul((double)control.getUpImpulse()).mul(control.getUpImpulse() < 0.0f ? EurekaConfig.SERVER.getBaseImpulseDescendRate() : EurekaConfig.SERVER.getBaseImpulseElevationRate() + this.smoothing(2.0, EurekaConfig.SERVER.getBalloonElevationMaxSpeed(), balloonForceProvided / mass));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            return vector3d;
        }
        return new Vector3d(0.0, 0.0, 0.0);
    }

    private final void showCruiseStatus() {
        block0: {
            String cruiseKey = this.isCruising ? "hud.vs_eureka.start_cruising" : "hud.vs_eureka.stop_cruising";
            Player player = this.seatedPlayer;
            if (player == null) break block0;
            player.m_5661_((Component)Component.m_237115_((String)cruiseKey), true);
        }
    }

    public final double getPowerLinear() {
        return this.powerLinear;
    }

    public final void setPowerLinear(double d) {
        this.powerLinear = d;
    }

    public final double getPowerAngular() {
        return this.powerAngular;
    }

    public final void setPowerAngular(double d) {
        this.powerAngular = d;
    }

    public final int getAnchors() {
        return this.anchors;
    }

    public final void setAnchors(int v) {
        this.anchors = v;
        this.deleteIfEmpty();
    }

    public final int getAnchorsActive() {
        return this.anchorsActive;
    }

    public final void setAnchorsActive(int n) {
        this.anchorsActive = n;
    }

    public final int getBalloons() {
        return this.balloons;
    }

    public final void setBalloons(int v) {
        this.balloons = v;
        this.deleteIfEmpty();
    }

    public final int getHelms() {
        return this.helms;
    }

    public final void setHelms(int v) {
        this.helms = v;
        this.deleteIfEmpty();
    }

    public final int getFloaters() {
        return this.floaters;
    }

    public final void setFloaters(int v) {
        this.floaters = v;
        this.deleteIfEmpty();
    }

    private final void deleteIfEmpty() {
        block1: {
            if (this.helms > 0 || this.floaters > 0 || this.anchors > 0 || this.balloons > 0) break block1;
            LoadedServerShip loadedServerShip = this.ship;
            if (loadedServerShip != null) {
                AttachmentHolder $this$removeAttachment$iv = (AttachmentHolder)loadedServerShip;
                boolean $i$f$removeAttachment = false;
                EurekaShipControl cfr_ignored_0 = (EurekaShipControl)$this$removeAttachment$iv.removeAttachment(EurekaShipControl.class);
            }
        }
    }

    private final double smoothing(double smoothing, double max, double x) {
        return max - smoothing / (x + smoothing / max);
    }

    private final double smoothingATan(double smoothing, double x) {
        return Math.atan(x * smoothing) / smoothing;
    }

    private final double smoothingATanMax(double max, double x) {
        return this.smoothingATan(1.0 / (max * 0.638), x);
    }

    public void onServerTick() {
        this.extraForceLinear = this.powerLinear;
        this.powerLinear = 0.0;
        this.extraForceAngular = this.powerAngular;
        this.powerAngular = 0.0;
        this.consumed = this.physConsumption * 0.1f;
        this.physConsumption = 0.0f;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/valkyrienskies/eureka/ship/EurekaShipControl$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "Ljava/util/function/Consumer;", "consumer", "", "deferUntilLoaded", "(Lorg/valkyrienskies/core/api/ships/ServerShip;Ljava/util/function/Consumer;)V", "", "ALIGN_THRESHOLD", "D", "DISASSEMBLE_THRESHOLD", "getForcePerBalloon", "()D", "forcePerBalloon", "GRAVITY", "<init>", "()V", "eureka-1201"})
    @SourceDebugExtension(value={"SMAP\nEurekaShipControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EurekaShipControl.kt\norg/valkyrienskies/eureka/ship/EurekaShipControl$Companion\n+ 2 AttachmentHolder.kt\norg/valkyrienskies/core/api/attachment/AttachmentHolderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,439:1\n66#2:440\n1#3:441\n*S KotlinDebug\n*F\n+ 1 EurekaShipControl.kt\norg/valkyrienskies/eureka/ship/EurekaShipControl$Companion\n*L\n405#1:440\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EurekaShipControl getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            AttachmentHolder $this$getAttachment$iv = (AttachmentHolder)ship;
            boolean $i$f$getAttachment = false;
            EurekaShipControl eurekaShipControl = (EurekaShipControl)$this$getAttachment$iv.getAttachment(EurekaShipControl.class);
            if (eurekaShipControl == null) {
                EurekaShipControl eurekaShipControl2;
                EurekaShipControl it = eurekaShipControl2 = new EurekaShipControl();
                boolean bl = false;
                ship.setAttachment((Object)it);
                eurekaShipControl = eurekaShipControl2;
            }
            return eurekaShipControl;
        }

        public final void deferUntilLoaded(@NotNull ServerShip ship, @NotNull Consumer<EurekaShipControl> consumer) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            if (ship instanceof LoadedServerShip) {
                consumer.accept(this.getOrCreate((LoadedServerShip)ship));
            } else {
                ValkyrienSkiesMod.getVsCore().getShipLoadEvent().once(arg_0 -> Companion.deferUntilLoaded$lambda$2(arg_0 -> Companion.deferUntilLoaded$lambda$1(ship, arg_0), arg_0), arg_0 -> Companion.deferUntilLoaded$lambda$4(arg_0 -> Companion.deferUntilLoaded$lambda$3(consumer, arg_0), arg_0));
            }
        }

        private final double getForcePerBalloon() {
            return EurekaConfig.SERVER.getMassPerBalloon() * 10.0;
        }

        private static final boolean deferUntilLoaded$lambda$1(ServerShip $ship, ShipLoadEvent event) {
            Intrinsics.checkNotNullParameter((Object)$ship, (String)"$ship");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return event.getShip().getId() == $ship.getId();
        }

        private static final boolean deferUntilLoaded$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit deferUntilLoaded$lambda$3(Consumer $consumer, ShipLoadEvent event) {
            Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            $consumer.accept(Companion.getOrCreate(event.getShip()));
            return Unit.INSTANCE;
        }

        private static final void deferUntilLoaded$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0082\b\u0018\u0000 -2\u00020\u0001:\u0001-B7\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0010\u0010\t\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJB\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0015\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001d\u001a\u0004\b\u001e\u0010\u0004R\"\u0010\u000e\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u001f\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\"R\"\u0010\u000f\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u001f\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\"R\"\u0010\u0010\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u001f\u001a\u0004\b%\u0010\u0007\"\u0004\b&\u0010\"R\"\u0010\u0011\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010'\u001a\u0004\b(\u0010\f\"\u0004\b)\u0010*\u00a8\u0006."}, d2={"Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "", "Lnet/minecraft/core/Direction;", "component1", "()Lnet/minecraft/core/Direction;", "", "component2", "()F", "component3", "component4", "", "component5", "()Z", "seatInDirection", "forwardImpulse", "leftImpulse", "upImpulse", "sprintOn", "copy", "(Lnet/minecraft/core/Direction;FFFZ)Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/core/Direction;", "getSeatInDirection", "F", "getForwardImpulse", "setForwardImpulse", "(F)V", "getLeftImpulse", "setLeftImpulse", "getUpImpulse", "setUpImpulse", "Z", "getSprintOn", "setSprintOn", "(Z)V", "<init>", "(Lnet/minecraft/core/Direction;FFFZ)V", "Companion", "eureka-1201"})
    private static final class ControlData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Direction seatInDirection;
        private float forwardImpulse;
        private float leftImpulse;
        private float upImpulse;
        private boolean sprintOn;

        public ControlData(@NotNull Direction seatInDirection, float forwardImpulse, float leftImpulse, float upImpulse, boolean sprintOn) {
            Intrinsics.checkNotNullParameter((Object)seatInDirection, (String)"seatInDirection");
            this.seatInDirection = seatInDirection;
            this.forwardImpulse = forwardImpulse;
            this.leftImpulse = leftImpulse;
            this.upImpulse = upImpulse;
            this.sprintOn = sprintOn;
        }

        public /* synthetic */ ControlData(Direction direction, float f, float f2, float f3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f = 0.0f;
            }
            if ((n & 4) != 0) {
                f2 = 0.0f;
            }
            if ((n & 8) != 0) {
                f3 = 0.0f;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(direction, f, f2, f3, bl);
        }

        @NotNull
        public final Direction getSeatInDirection() {
            return this.seatInDirection;
        }

        public final float getForwardImpulse() {
            return this.forwardImpulse;
        }

        public final void setForwardImpulse(float f) {
            this.forwardImpulse = f;
        }

        public final float getLeftImpulse() {
            return this.leftImpulse;
        }

        public final void setLeftImpulse(float f) {
            this.leftImpulse = f;
        }

        public final float getUpImpulse() {
            return this.upImpulse;
        }

        public final void setUpImpulse(float f) {
            this.upImpulse = f;
        }

        public final boolean getSprintOn() {
            return this.sprintOn;
        }

        public final void setSprintOn(boolean bl) {
            this.sprintOn = bl;
        }

        @NotNull
        public final Direction component1() {
            return this.seatInDirection;
        }

        public final float component2() {
            return this.forwardImpulse;
        }

        public final float component3() {
            return this.leftImpulse;
        }

        public final float component4() {
            return this.upImpulse;
        }

        public final boolean component5() {
            return this.sprintOn;
        }

        @NotNull
        public final ControlData copy(@NotNull Direction seatInDirection, float forwardImpulse, float leftImpulse, float upImpulse, boolean sprintOn) {
            Intrinsics.checkNotNullParameter((Object)seatInDirection, (String)"seatInDirection");
            return new ControlData(seatInDirection, forwardImpulse, leftImpulse, upImpulse, sprintOn);
        }

        public static /* synthetic */ ControlData copy$default(ControlData controlData, Direction direction, float f, float f2, float f3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                direction = controlData.seatInDirection;
            }
            if ((n & 2) != 0) {
                f = controlData.forwardImpulse;
            }
            if ((n & 4) != 0) {
                f2 = controlData.leftImpulse;
            }
            if ((n & 8) != 0) {
                f3 = controlData.upImpulse;
            }
            if ((n & 0x10) != 0) {
                bl = controlData.sprintOn;
            }
            return controlData.copy(direction, f, f2, f3, bl);
        }

        @NotNull
        public String toString() {
            return "ControlData(seatInDirection=" + this.seatInDirection + ", forwardImpulse=" + this.forwardImpulse + ", leftImpulse=" + this.leftImpulse + ", upImpulse=" + this.upImpulse + ", sprintOn=" + this.sprintOn + ")";
        }

        public int hashCode() {
            int result = this.seatInDirection.hashCode();
            result = result * 31 + Float.hashCode(this.forwardImpulse);
            result = result * 31 + Float.hashCode(this.leftImpulse);
            result = result * 31 + Float.hashCode(this.upImpulse);
            result = result * 31 + Boolean.hashCode(this.sprintOn);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ControlData)) {
                return false;
            }
            ControlData controlData = (ControlData)other;
            if (this.seatInDirection != controlData.seatInDirection) {
                return false;
            }
            if (Float.compare(this.forwardImpulse, controlData.forwardImpulse) != 0) {
                return false;
            }
            if (Float.compare(this.leftImpulse, controlData.leftImpulse) != 0) {
                return false;
            }
            if (Float.compare(this.upImpulse, controlData.upImpulse) != 0) {
                return false;
            }
            return this.sprintOn == controlData.sprintOn;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData$Companion;", "", "Lorg/valkyrienskies/mod/api/SeatedControllingPlayer;", "player", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "create", "(Lorg/valkyrienskies/mod/api/SeatedControllingPlayer;)Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "<init>", "()V", "eureka-1201"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ControlData create(@NotNull SeatedControllingPlayer player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return new ControlData(player.getSeatInDirection(), player.getForwardImpulse(), player.getLeftImpulse(), player.getUpImpulse(), player.getSprintOn());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

